/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Customer;
import com.squareup.square.types.CustomerCreatedEventEventContext;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CustomerCreatedEventObject {
    private final Optional<Customer> customer;
    private final Optional<CustomerCreatedEventEventContext> eventContext;
    private final Map<String, Object> additionalProperties;

    private CustomerCreatedEventObject(Optional<Customer> customer, Optional<CustomerCreatedEventEventContext> eventContext, Map<String, Object> additionalProperties) {
        this.customer = customer;
        this.eventContext = eventContext;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="customer")
    public Optional<Customer> getCustomer() {
        return this.customer;
    }

    @JsonProperty(value="event_context")
    public Optional<CustomerCreatedEventEventContext> getEventContext() {
        return this.eventContext;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CustomerCreatedEventObject && this.equalTo((CustomerCreatedEventObject)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CustomerCreatedEventObject other) {
        return this.customer.equals(other.customer) && this.eventContext.equals(other.eventContext);
    }

    public int hashCode() {
        return Objects.hash(this.customer, this.eventContext);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Customer> customer = Optional.empty();
        private Optional<CustomerCreatedEventEventContext> eventContext = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CustomerCreatedEventObject other) {
            this.customer(other.getCustomer());
            this.eventContext(other.getEventContext());
            return this;
        }

        @JsonSetter(value="customer", nulls=Nulls.SKIP)
        public Builder customer(Optional<Customer> customer) {
            this.customer = customer;
            return this;
        }

        public Builder customer(Customer customer) {
            this.customer = Optional.ofNullable(customer);
            return this;
        }

        @JsonSetter(value="event_context", nulls=Nulls.SKIP)
        public Builder eventContext(Optional<CustomerCreatedEventEventContext> eventContext) {
            this.eventContext = eventContext;
            return this;
        }

        public Builder eventContext(CustomerCreatedEventEventContext eventContext) {
            this.eventContext = Optional.ofNullable(eventContext);
            return this;
        }

        public CustomerCreatedEventObject build() {
            return new CustomerCreatedEventObject(this.customer, this.eventContext, this.additionalProperties);
        }
    }
}

