/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Address;
import com.squareup.square.types.CustomerCreationSource;
import com.squareup.square.types.CustomerPreferences;
import com.squareup.square.types.CustomerTaxIds;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Customer {
    private final Optional<String> id;
    private final Optional<String> createdAt;
    private final Optional<String> updatedAt;
    private final Optional<String> givenName;
    private final Optional<String> familyName;
    private final Optional<String> nickname;
    private final Optional<String> companyName;
    private final Optional<String> emailAddress;
    private final Optional<Address> address;
    private final Optional<String> phoneNumber;
    private final Optional<String> birthday;
    private final Optional<String> referenceId;
    private final Optional<String> note;
    private final Optional<CustomerPreferences> preferences;
    private final Optional<CustomerCreationSource> creationSource;
    private final Optional<List<String>> groupIds;
    private final Optional<List<String>> segmentIds;
    private final Optional<Long> version;
    private final Optional<CustomerTaxIds> taxIds;
    private final Map<String, Object> additionalProperties;

    private Customer(Optional<String> id, Optional<String> createdAt, Optional<String> updatedAt, Optional<String> givenName, Optional<String> familyName, Optional<String> nickname, Optional<String> companyName, Optional<String> emailAddress, Optional<Address> address, Optional<String> phoneNumber, Optional<String> birthday, Optional<String> referenceId, Optional<String> note, Optional<CustomerPreferences> preferences, Optional<CustomerCreationSource> creationSource, Optional<List<String>> groupIds, Optional<List<String>> segmentIds, Optional<Long> version, Optional<CustomerTaxIds> taxIds, Map<String, Object> additionalProperties) {
        this.id = id;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.givenName = givenName;
        this.familyName = familyName;
        this.nickname = nickname;
        this.companyName = companyName;
        this.emailAddress = emailAddress;
        this.address = address;
        this.phoneNumber = phoneNumber;
        this.birthday = birthday;
        this.referenceId = referenceId;
        this.note = note;
        this.preferences = preferences;
        this.creationSource = creationSource;
        this.groupIds = groupIds;
        this.segmentIds = segmentIds;
        this.version = version;
        this.taxIds = taxIds;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="created_at")
    public Optional<String> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public Optional<String> getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonIgnore
    public Optional<String> getGivenName() {
        if (this.givenName == null) {
            return Optional.empty();
        }
        return this.givenName;
    }

    @JsonIgnore
    public Optional<String> getFamilyName() {
        if (this.familyName == null) {
            return Optional.empty();
        }
        return this.familyName;
    }

    @JsonIgnore
    public Optional<String> getNickname() {
        if (this.nickname == null) {
            return Optional.empty();
        }
        return this.nickname;
    }

    @JsonIgnore
    public Optional<String> getCompanyName() {
        if (this.companyName == null) {
            return Optional.empty();
        }
        return this.companyName;
    }

    @JsonIgnore
    public Optional<String> getEmailAddress() {
        if (this.emailAddress == null) {
            return Optional.empty();
        }
        return this.emailAddress;
    }

    @JsonProperty(value="address")
    public Optional<Address> getAddress() {
        return this.address;
    }

    @JsonIgnore
    public Optional<String> getPhoneNumber() {
        if (this.phoneNumber == null) {
            return Optional.empty();
        }
        return this.phoneNumber;
    }

    @JsonIgnore
    public Optional<String> getBirthday() {
        if (this.birthday == null) {
            return Optional.empty();
        }
        return this.birthday;
    }

    @JsonIgnore
    public Optional<String> getReferenceId() {
        if (this.referenceId == null) {
            return Optional.empty();
        }
        return this.referenceId;
    }

    @JsonIgnore
    public Optional<String> getNote() {
        if (this.note == null) {
            return Optional.empty();
        }
        return this.note;
    }

    @JsonProperty(value="preferences")
    public Optional<CustomerPreferences> getPreferences() {
        return this.preferences;
    }

    @JsonProperty(value="creation_source")
    public Optional<CustomerCreationSource> getCreationSource() {
        return this.creationSource;
    }

    @JsonIgnore
    public Optional<List<String>> getGroupIds() {
        if (this.groupIds == null) {
            return Optional.empty();
        }
        return this.groupIds;
    }

    @JsonIgnore
    public Optional<List<String>> getSegmentIds() {
        if (this.segmentIds == null) {
            return Optional.empty();
        }
        return this.segmentIds;
    }

    @JsonProperty(value="version")
    public Optional<Long> getVersion() {
        return this.version;
    }

    @JsonProperty(value="tax_ids")
    public Optional<CustomerTaxIds> getTaxIds() {
        return this.taxIds;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="given_name")
    private Optional<String> _getGivenName() {
        return this.givenName;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="family_name")
    private Optional<String> _getFamilyName() {
        return this.familyName;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="nickname")
    private Optional<String> _getNickname() {
        return this.nickname;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="company_name")
    private Optional<String> _getCompanyName() {
        return this.companyName;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="email_address")
    private Optional<String> _getEmailAddress() {
        return this.emailAddress;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="phone_number")
    private Optional<String> _getPhoneNumber() {
        return this.phoneNumber;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="birthday")
    private Optional<String> _getBirthday() {
        return this.birthday;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="reference_id")
    private Optional<String> _getReferenceId() {
        return this.referenceId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="note")
    private Optional<String> _getNote() {
        return this.note;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="group_ids")
    private Optional<List<String>> _getGroupIds() {
        return this.groupIds;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="segment_ids")
    private Optional<List<String>> _getSegmentIds() {
        return this.segmentIds;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Customer && this.equalTo((Customer)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Customer other) {
        return this.id.equals(other.id) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt) && this.givenName.equals(other.givenName) && this.familyName.equals(other.familyName) && this.nickname.equals(other.nickname) && this.companyName.equals(other.companyName) && this.emailAddress.equals(other.emailAddress) && this.address.equals(other.address) && this.phoneNumber.equals(other.phoneNumber) && this.birthday.equals(other.birthday) && this.referenceId.equals(other.referenceId) && this.note.equals(other.note) && this.preferences.equals(other.preferences) && this.creationSource.equals(other.creationSource) && this.groupIds.equals(other.groupIds) && this.segmentIds.equals(other.segmentIds) && this.version.equals(other.version) && this.taxIds.equals(other.taxIds);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.createdAt, this.updatedAt, this.givenName, this.familyName, this.nickname, this.companyName, this.emailAddress, this.address, this.phoneNumber, this.birthday, this.referenceId, this.note, this.preferences, this.creationSource, this.groupIds, this.segmentIds, this.version, this.taxIds);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<String> createdAt = Optional.empty();
        private Optional<String> updatedAt = Optional.empty();
        private Optional<String> givenName = Optional.empty();
        private Optional<String> familyName = Optional.empty();
        private Optional<String> nickname = Optional.empty();
        private Optional<String> companyName = Optional.empty();
        private Optional<String> emailAddress = Optional.empty();
        private Optional<Address> address = Optional.empty();
        private Optional<String> phoneNumber = Optional.empty();
        private Optional<String> birthday = Optional.empty();
        private Optional<String> referenceId = Optional.empty();
        private Optional<String> note = Optional.empty();
        private Optional<CustomerPreferences> preferences = Optional.empty();
        private Optional<CustomerCreationSource> creationSource = Optional.empty();
        private Optional<List<String>> groupIds = Optional.empty();
        private Optional<List<String>> segmentIds = Optional.empty();
        private Optional<Long> version = Optional.empty();
        private Optional<CustomerTaxIds> taxIds = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(Customer other) {
            this.id(other.getId());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            this.givenName(other.getGivenName());
            this.familyName(other.getFamilyName());
            this.nickname(other.getNickname());
            this.companyName(other.getCompanyName());
            this.emailAddress(other.getEmailAddress());
            this.address(other.getAddress());
            this.phoneNumber(other.getPhoneNumber());
            this.birthday(other.getBirthday());
            this.referenceId(other.getReferenceId());
            this.note(other.getNote());
            this.preferences(other.getPreferences());
            this.creationSource(other.getCreationSource());
            this.groupIds(other.getGroupIds());
            this.segmentIds(other.getSegmentIds());
            this.version(other.getVersion());
            this.taxIds(other.getTaxIds());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<String> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public Builder updatedAt(Optional<String> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @JsonSetter(value="given_name", nulls=Nulls.SKIP)
        public Builder givenName(Optional<String> givenName) {
            this.givenName = givenName;
            return this;
        }

        public Builder givenName(String givenName) {
            this.givenName = Optional.ofNullable(givenName);
            return this;
        }

        public Builder givenName(Nullable<String> givenName) {
            this.givenName = givenName.isNull() ? null : (givenName.isEmpty() ? Optional.empty() : Optional.of(givenName.get()));
            return this;
        }

        @JsonSetter(value="family_name", nulls=Nulls.SKIP)
        public Builder familyName(Optional<String> familyName) {
            this.familyName = familyName;
            return this;
        }

        public Builder familyName(String familyName) {
            this.familyName = Optional.ofNullable(familyName);
            return this;
        }

        public Builder familyName(Nullable<String> familyName) {
            this.familyName = familyName.isNull() ? null : (familyName.isEmpty() ? Optional.empty() : Optional.of(familyName.get()));
            return this;
        }

        @JsonSetter(value="nickname", nulls=Nulls.SKIP)
        public Builder nickname(Optional<String> nickname) {
            this.nickname = nickname;
            return this;
        }

        public Builder nickname(String nickname) {
            this.nickname = Optional.ofNullable(nickname);
            return this;
        }

        public Builder nickname(Nullable<String> nickname) {
            this.nickname = nickname.isNull() ? null : (nickname.isEmpty() ? Optional.empty() : Optional.of(nickname.get()));
            return this;
        }

        @JsonSetter(value="company_name", nulls=Nulls.SKIP)
        public Builder companyName(Optional<String> companyName) {
            this.companyName = companyName;
            return this;
        }

        public Builder companyName(String companyName) {
            this.companyName = Optional.ofNullable(companyName);
            return this;
        }

        public Builder companyName(Nullable<String> companyName) {
            this.companyName = companyName.isNull() ? null : (companyName.isEmpty() ? Optional.empty() : Optional.of(companyName.get()));
            return this;
        }

        @JsonSetter(value="email_address", nulls=Nulls.SKIP)
        public Builder emailAddress(Optional<String> emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public Builder emailAddress(String emailAddress) {
            this.emailAddress = Optional.ofNullable(emailAddress);
            return this;
        }

        public Builder emailAddress(Nullable<String> emailAddress) {
            this.emailAddress = emailAddress.isNull() ? null : (emailAddress.isEmpty() ? Optional.empty() : Optional.of(emailAddress.get()));
            return this;
        }

        @JsonSetter(value="address", nulls=Nulls.SKIP)
        public Builder address(Optional<Address> address) {
            this.address = address;
            return this;
        }

        public Builder address(Address address) {
            this.address = Optional.ofNullable(address);
            return this;
        }

        @JsonSetter(value="phone_number", nulls=Nulls.SKIP)
        public Builder phoneNumber(Optional<String> phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = Optional.ofNullable(phoneNumber);
            return this;
        }

        public Builder phoneNumber(Nullable<String> phoneNumber) {
            this.phoneNumber = phoneNumber.isNull() ? null : (phoneNumber.isEmpty() ? Optional.empty() : Optional.of(phoneNumber.get()));
            return this;
        }

        @JsonSetter(value="birthday", nulls=Nulls.SKIP)
        public Builder birthday(Optional<String> birthday) {
            this.birthday = birthday;
            return this;
        }

        public Builder birthday(String birthday) {
            this.birthday = Optional.ofNullable(birthday);
            return this;
        }

        public Builder birthday(Nullable<String> birthday) {
            this.birthday = birthday.isNull() ? null : (birthday.isEmpty() ? Optional.empty() : Optional.of(birthday.get()));
            return this;
        }

        @JsonSetter(value="reference_id", nulls=Nulls.SKIP)
        public Builder referenceId(Optional<String> referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public Builder referenceId(String referenceId) {
            this.referenceId = Optional.ofNullable(referenceId);
            return this;
        }

        public Builder referenceId(Nullable<String> referenceId) {
            this.referenceId = referenceId.isNull() ? null : (referenceId.isEmpty() ? Optional.empty() : Optional.of(referenceId.get()));
            return this;
        }

        @JsonSetter(value="note", nulls=Nulls.SKIP)
        public Builder note(Optional<String> note) {
            this.note = note;
            return this;
        }

        public Builder note(String note) {
            this.note = Optional.ofNullable(note);
            return this;
        }

        public Builder note(Nullable<String> note) {
            this.note = note.isNull() ? null : (note.isEmpty() ? Optional.empty() : Optional.of(note.get()));
            return this;
        }

        @JsonSetter(value="preferences", nulls=Nulls.SKIP)
        public Builder preferences(Optional<CustomerPreferences> preferences) {
            this.preferences = preferences;
            return this;
        }

        public Builder preferences(CustomerPreferences preferences) {
            this.preferences = Optional.ofNullable(preferences);
            return this;
        }

        @JsonSetter(value="creation_source", nulls=Nulls.SKIP)
        public Builder creationSource(Optional<CustomerCreationSource> creationSource) {
            this.creationSource = creationSource;
            return this;
        }

        public Builder creationSource(CustomerCreationSource creationSource) {
            this.creationSource = Optional.ofNullable(creationSource);
            return this;
        }

        @JsonSetter(value="group_ids", nulls=Nulls.SKIP)
        public Builder groupIds(Optional<List<String>> groupIds) {
            this.groupIds = groupIds;
            return this;
        }

        public Builder groupIds(List<String> groupIds) {
            this.groupIds = Optional.ofNullable(groupIds);
            return this;
        }

        public Builder groupIds(Nullable<List<String>> groupIds) {
            this.groupIds = groupIds.isNull() ? null : (groupIds.isEmpty() ? Optional.empty() : Optional.of(groupIds.get()));
            return this;
        }

        @JsonSetter(value="segment_ids", nulls=Nulls.SKIP)
        public Builder segmentIds(Optional<List<String>> segmentIds) {
            this.segmentIds = segmentIds;
            return this;
        }

        public Builder segmentIds(List<String> segmentIds) {
            this.segmentIds = Optional.ofNullable(segmentIds);
            return this;
        }

        public Builder segmentIds(Nullable<List<String>> segmentIds) {
            this.segmentIds = segmentIds.isNull() ? null : (segmentIds.isEmpty() ? Optional.empty() : Optional.of(segmentIds.get()));
            return this;
        }

        @JsonSetter(value="version", nulls=Nulls.SKIP)
        public Builder version(Optional<Long> version) {
            this.version = version;
            return this;
        }

        public Builder version(Long version) {
            this.version = Optional.ofNullable(version);
            return this;
        }

        @JsonSetter(value="tax_ids", nulls=Nulls.SKIP)
        public Builder taxIds(Optional<CustomerTaxIds> taxIds) {
            this.taxIds = taxIds;
            return this;
        }

        public Builder taxIds(CustomerTaxIds taxIds) {
            this.taxIds = Optional.ofNullable(taxIds);
            return this;
        }

        public Customer build() {
            return new Customer(this.id, this.createdAt, this.updatedAt, this.givenName, this.familyName, this.nickname, this.companyName, this.emailAddress, this.address, this.phoneNumber, this.birthday, this.referenceId, this.note, this.preferences, this.creationSource, this.groupIds, this.segmentIds, this.version, this.taxIds, this.additionalProperties);
        }
    }
}

