/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CustomAttributeDefinitionVisibility;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CustomAttributeDefinition {
    private final Optional<String> key;
    private final Optional<Map<String, Object>> schema;
    private final Optional<String> name;
    private final Optional<String> description;
    private final Optional<CustomAttributeDefinitionVisibility> visibility;
    private final Optional<Integer> version;
    private final Optional<String> updatedAt;
    private final Optional<String> createdAt;
    private final Map<String, Object> additionalProperties;

    private CustomAttributeDefinition(Optional<String> key, Optional<Map<String, Object>> schema, Optional<String> name, Optional<String> description, Optional<CustomAttributeDefinitionVisibility> visibility, Optional<Integer> version, Optional<String> updatedAt, Optional<String> createdAt, Map<String, Object> additionalProperties) {
        this.key = key;
        this.schema = schema;
        this.name = name;
        this.description = description;
        this.visibility = visibility;
        this.version = version;
        this.updatedAt = updatedAt;
        this.createdAt = createdAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getKey() {
        if (this.key == null) {
            return Optional.empty();
        }
        return this.key;
    }

    @JsonIgnore
    public Optional<Map<String, Object>> getSchema() {
        if (this.schema == null) {
            return Optional.empty();
        }
        return this.schema;
    }

    @JsonIgnore
    public Optional<String> getName() {
        if (this.name == null) {
            return Optional.empty();
        }
        return this.name;
    }

    @JsonIgnore
    public Optional<String> getDescription() {
        if (this.description == null) {
            return Optional.empty();
        }
        return this.description;
    }

    @JsonProperty(value="visibility")
    public Optional<CustomAttributeDefinitionVisibility> getVisibility() {
        return this.visibility;
    }

    @JsonProperty(value="version")
    public Optional<Integer> getVersion() {
        return this.version;
    }

    @JsonProperty(value="updated_at")
    public Optional<String> getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="created_at")
    public Optional<String> getCreatedAt() {
        return this.createdAt;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="key")
    private Optional<String> _getKey() {
        return this.key;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="schema")
    private Optional<Map<String, Object>> _getSchema() {
        return this.schema;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="name")
    private Optional<String> _getName() {
        return this.name;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="description")
    private Optional<String> _getDescription() {
        return this.description;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CustomAttributeDefinition && this.equalTo((CustomAttributeDefinition)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CustomAttributeDefinition other) {
        return this.key.equals(other.key) && this.schema.equals(other.schema) && this.name.equals(other.name) && this.description.equals(other.description) && this.visibility.equals(other.visibility) && this.version.equals(other.version) && this.updatedAt.equals(other.updatedAt) && this.createdAt.equals(other.createdAt);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.schema, this.name, this.description, this.visibility, this.version, this.updatedAt, this.createdAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> key = Optional.empty();
        private Optional<Map<String, Object>> schema = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<String> description = Optional.empty();
        private Optional<CustomAttributeDefinitionVisibility> visibility = Optional.empty();
        private Optional<Integer> version = Optional.empty();
        private Optional<String> updatedAt = Optional.empty();
        private Optional<String> createdAt = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CustomAttributeDefinition other) {
            this.key(other.getKey());
            this.schema(other.getSchema());
            this.name(other.getName());
            this.description(other.getDescription());
            this.visibility(other.getVisibility());
            this.version(other.getVersion());
            this.updatedAt(other.getUpdatedAt());
            this.createdAt(other.getCreatedAt());
            return this;
        }

        @JsonSetter(value="key", nulls=Nulls.SKIP)
        public Builder key(Optional<String> key) {
            this.key = key;
            return this;
        }

        public Builder key(String key) {
            this.key = Optional.ofNullable(key);
            return this;
        }

        public Builder key(Nullable<String> key) {
            this.key = key.isNull() ? null : (key.isEmpty() ? Optional.empty() : Optional.of(key.get()));
            return this;
        }

        @JsonSetter(value="schema", nulls=Nulls.SKIP)
        public Builder schema(Optional<Map<String, Object>> schema) {
            this.schema = schema;
            return this;
        }

        public Builder schema(Map<String, Object> schema) {
            this.schema = Optional.ofNullable(schema);
            return this;
        }

        public Builder schema(Nullable<Map<String, Object>> schema) {
            this.schema = schema.isNull() ? null : (schema.isEmpty() ? Optional.empty() : Optional.of(schema.get()));
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        public Builder name(Nullable<String> name) {
            this.name = name.isNull() ? null : (name.isEmpty() ? Optional.empty() : Optional.of(name.get()));
            return this;
        }

        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public Builder description(Optional<String> description) {
            this.description = description;
            return this;
        }

        public Builder description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        public Builder description(Nullable<String> description) {
            this.description = description.isNull() ? null : (description.isEmpty() ? Optional.empty() : Optional.of(description.get()));
            return this;
        }

        @JsonSetter(value="visibility", nulls=Nulls.SKIP)
        public Builder visibility(Optional<CustomAttributeDefinitionVisibility> visibility) {
            this.visibility = visibility;
            return this;
        }

        public Builder visibility(CustomAttributeDefinitionVisibility visibility) {
            this.visibility = Optional.ofNullable(visibility);
            return this;
        }

        @JsonSetter(value="version", nulls=Nulls.SKIP)
        public Builder version(Optional<Integer> version) {
            this.version = version;
            return this;
        }

        public Builder version(Integer version) {
            this.version = Optional.ofNullable(version);
            return this;
        }

        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public Builder updatedAt(Optional<String> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<String> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        public CustomAttributeDefinition build() {
            return new CustomAttributeDefinition(this.key, this.schema, this.name, this.description, this.visibility, this.version, this.updatedAt, this.createdAt, this.additionalProperties);
        }
    }
}

