/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Vendor;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateVendorRequest {
    private final String idempotencyKey;
    private final Optional<Vendor> vendor;
    private final Map<String, Object> additionalProperties;

    private CreateVendorRequest(String idempotencyKey, Optional<Vendor> vendor, Map<String, Object> additionalProperties) {
        this.idempotencyKey = idempotencyKey;
        this.vendor = vendor;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="idempotency_key")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonProperty(value="vendor")
    public Optional<Vendor> getVendor() {
        return this.vendor;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateVendorRequest && this.equalTo((CreateVendorRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateVendorRequest other) {
        return this.idempotencyKey.equals(other.idempotencyKey) && this.vendor.equals(other.vendor);
    }

    public int hashCode() {
        return Objects.hash(this.idempotencyKey, this.vendor);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdempotencyKeyStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdempotencyKeyStage,
    _FinalStage {
        private String idempotencyKey;
        private Optional<Vendor> vendor = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateVendorRequest other) {
            this.idempotencyKey(other.getIdempotencyKey());
            this.vendor(other.getVendor());
            return this;
        }

        @Override
        @JsonSetter(value="idempotency_key")
        public _FinalStage idempotencyKey(@NotNull String idempotencyKey) {
            this.idempotencyKey = Objects.requireNonNull(idempotencyKey, "idempotencyKey must not be null");
            return this;
        }

        @Override
        public _FinalStage vendor(Vendor vendor) {
            this.vendor = Optional.ofNullable(vendor);
            return this;
        }

        @Override
        @JsonSetter(value="vendor", nulls=Nulls.SKIP)
        public _FinalStage vendor(Optional<Vendor> vendor) {
            this.vendor = vendor;
            return this;
        }

        @Override
        public CreateVendorRequest build() {
            return new CreateVendorRequest(this.idempotencyKey, this.vendor, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateVendorRequest build();

        public _FinalStage vendor(Optional<Vendor> var1);

        public _FinalStage vendor(Vendor var1);
    }

    public static interface IdempotencyKeyStage {
        public _FinalStage idempotencyKey(@NotNull String var1);

        public Builder from(CreateVendorRequest var1);
    }
}

