/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Error;
import com.squareup.square.types.Order;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateOrderResponse {
    private final Optional<Order> order;
    private final Optional<List<Error>> errors;
    private final Map<String, Object> additionalProperties;

    private CreateOrderResponse(Optional<Order> order, Optional<List<Error>> errors, Map<String, Object> additionalProperties) {
        this.order = order;
        this.errors = errors;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="order")
    public Optional<Order> getOrder() {
        return this.order;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateOrderResponse && this.equalTo((CreateOrderResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateOrderResponse other) {
        return this.order.equals(other.order) && this.errors.equals(other.errors);
    }

    public int hashCode() {
        return Objects.hash(this.order, this.errors);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Order> order = Optional.empty();
        private Optional<List<Error>> errors = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CreateOrderResponse other) {
            this.order(other.getOrder());
            this.errors(other.getErrors());
            return this;
        }

        @JsonSetter(value="order", nulls=Nulls.SKIP)
        public Builder order(Optional<Order> order) {
            this.order = order;
            return this;
        }

        public Builder order(Order order) {
            this.order = Optional.ofNullable(order);
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        public CreateOrderResponse build() {
            return new CreateOrderResponse(this.order, this.errors, this.additionalProperties);
        }
    }
}

