/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Error;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateMobileAuthorizationCodeResponse {
    private final Optional<String> authorizationCode;
    private final Optional<String> expiresAt;
    private final Optional<List<Error>> errors;
    private final Map<String, Object> additionalProperties;

    private CreateMobileAuthorizationCodeResponse(Optional<String> authorizationCode, Optional<String> expiresAt, Optional<List<Error>> errors, Map<String, Object> additionalProperties) {
        this.authorizationCode = authorizationCode;
        this.expiresAt = expiresAt;
        this.errors = errors;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="authorization_code")
    public Optional<String> getAuthorizationCode() {
        return this.authorizationCode;
    }

    @JsonProperty(value="expires_at")
    public Optional<String> getExpiresAt() {
        return this.expiresAt;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateMobileAuthorizationCodeResponse && this.equalTo((CreateMobileAuthorizationCodeResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateMobileAuthorizationCodeResponse other) {
        return this.authorizationCode.equals(other.authorizationCode) && this.expiresAt.equals(other.expiresAt) && this.errors.equals(other.errors);
    }

    public int hashCode() {
        return Objects.hash(this.authorizationCode, this.expiresAt, this.errors);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> authorizationCode = Optional.empty();
        private Optional<String> expiresAt = Optional.empty();
        private Optional<List<Error>> errors = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CreateMobileAuthorizationCodeResponse other) {
            this.authorizationCode(other.getAuthorizationCode());
            this.expiresAt(other.getExpiresAt());
            this.errors(other.getErrors());
            return this;
        }

        @JsonSetter(value="authorization_code", nulls=Nulls.SKIP)
        public Builder authorizationCode(Optional<String> authorizationCode) {
            this.authorizationCode = authorizationCode;
            return this;
        }

        public Builder authorizationCode(String authorizationCode) {
            this.authorizationCode = Optional.ofNullable(authorizationCode);
            return this;
        }

        @JsonSetter(value="expires_at", nulls=Nulls.SKIP)
        public Builder expiresAt(Optional<String> expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        public Builder expiresAt(String expiresAt) {
            this.expiresAt = Optional.ofNullable(expiresAt);
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        public CreateMobileAuthorizationCodeResponse build() {
            return new CreateMobileAuthorizationCodeResponse(this.authorizationCode, this.expiresAt, this.errors, this.additionalProperties);
        }
    }
}

