/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Location;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateLocationRequest {
    private final Optional<Location> location;
    private final Map<String, Object> additionalProperties;

    private CreateLocationRequest(Optional<Location> location, Map<String, Object> additionalProperties) {
        this.location = location;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="location")
    public Optional<Location> getLocation() {
        return this.location;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateLocationRequest && this.equalTo((CreateLocationRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateLocationRequest other) {
        return this.location.equals(other.location);
    }

    public int hashCode() {
        return Objects.hash(this.location);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Location> location = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CreateLocationRequest other) {
            this.location(other.getLocation());
            return this;
        }

        @JsonSetter(value="location", nulls=Nulls.SKIP)
        public Builder location(Optional<Location> location) {
            this.location = location;
            return this;
        }

        public Builder location(Location location) {
            this.location = Optional.ofNullable(location);
            return this;
        }

        public CreateLocationRequest build() {
            return new CreateLocationRequest(this.location, this.additionalProperties);
        }
    }
}

