/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Invoice;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateInvoiceRequest {
    private final Invoice invoice;
    private final Optional<String> idempotencyKey;
    private final Map<String, Object> additionalProperties;

    private CreateInvoiceRequest(Invoice invoice, Optional<String> idempotencyKey, Map<String, Object> additionalProperties) {
        this.invoice = invoice;
        this.idempotencyKey = idempotencyKey;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="invoice")
    public Invoice getInvoice() {
        return this.invoice;
    }

    @JsonProperty(value="idempotency_key")
    public Optional<String> getIdempotencyKey() {
        return this.idempotencyKey;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateInvoiceRequest && this.equalTo((CreateInvoiceRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateInvoiceRequest other) {
        return this.invoice.equals(other.invoice) && this.idempotencyKey.equals(other.idempotencyKey);
    }

    public int hashCode() {
        return Objects.hash(this.invoice, this.idempotencyKey);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static InvoiceStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements InvoiceStage,
    _FinalStage {
        private Invoice invoice;
        private Optional<String> idempotencyKey = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateInvoiceRequest other) {
            this.invoice(other.getInvoice());
            this.idempotencyKey(other.getIdempotencyKey());
            return this;
        }

        @Override
        @JsonSetter(value="invoice")
        public _FinalStage invoice(@NotNull Invoice invoice) {
            this.invoice = Objects.requireNonNull(invoice, "invoice must not be null");
            return this;
        }

        @Override
        public _FinalStage idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = Optional.ofNullable(idempotencyKey);
            return this;
        }

        @Override
        @JsonSetter(value="idempotency_key", nulls=Nulls.SKIP)
        public _FinalStage idempotencyKey(Optional<String> idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        @Override
        public CreateInvoiceRequest build() {
            return new CreateInvoiceRequest(this.invoice, this.idempotencyKey, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateInvoiceRequest build();

        public _FinalStage idempotencyKey(Optional<String> var1);

        public _FinalStage idempotencyKey(String var1);
    }

    public static interface InvoiceStage {
        public _FinalStage invoice(@NotNull Invoice var1);

        public Builder from(CreateInvoiceRequest var1);
    }
}

