/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Error;
import com.squareup.square.types.InvoiceAttachment;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateInvoiceAttachmentResponse {
    private final Optional<InvoiceAttachment> attachment;
    private final Optional<List<Error>> errors;
    private final Map<String, Object> additionalProperties;

    private CreateInvoiceAttachmentResponse(Optional<InvoiceAttachment> attachment, Optional<List<Error>> errors, Map<String, Object> additionalProperties) {
        this.attachment = attachment;
        this.errors = errors;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="attachment")
    public Optional<InvoiceAttachment> getAttachment() {
        return this.attachment;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateInvoiceAttachmentResponse && this.equalTo((CreateInvoiceAttachmentResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateInvoiceAttachmentResponse other) {
        return this.attachment.equals(other.attachment) && this.errors.equals(other.errors);
    }

    public int hashCode() {
        return Objects.hash(this.attachment, this.errors);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<InvoiceAttachment> attachment = Optional.empty();
        private Optional<List<Error>> errors = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CreateInvoiceAttachmentResponse other) {
            this.attachment(other.getAttachment());
            this.errors(other.getErrors());
            return this;
        }

        @JsonSetter(value="attachment", nulls=Nulls.SKIP)
        public Builder attachment(Optional<InvoiceAttachment> attachment) {
            this.attachment = attachment;
            return this;
        }

        public Builder attachment(InvoiceAttachment attachment) {
            this.attachment = Optional.ofNullable(attachment);
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        public CreateInvoiceAttachmentResponse build() {
            return new CreateInvoiceAttachmentResponse(this.attachment, this.errors, this.additionalProperties);
        }
    }
}

