/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateInvoiceAttachmentRequestData {
    private final Optional<String> idempotencyKey;
    private final Optional<String> description;
    private final Map<String, Object> additionalProperties;

    private CreateInvoiceAttachmentRequestData(Optional<String> idempotencyKey, Optional<String> description, Map<String, Object> additionalProperties) {
        this.idempotencyKey = idempotencyKey;
        this.description = description;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="idempotency_key")
    public Optional<String> getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return this.description;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateInvoiceAttachmentRequestData && this.equalTo((CreateInvoiceAttachmentRequestData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateInvoiceAttachmentRequestData other) {
        return this.idempotencyKey.equals(other.idempotencyKey) && this.description.equals(other.description);
    }

    public int hashCode() {
        return Objects.hash(this.idempotencyKey, this.description);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> idempotencyKey = Optional.empty();
        private Optional<String> description = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CreateInvoiceAttachmentRequestData other) {
            this.idempotencyKey(other.getIdempotencyKey());
            this.description(other.getDescription());
            return this;
        }

        @JsonSetter(value="idempotency_key", nulls=Nulls.SKIP)
        public Builder idempotencyKey(Optional<String> idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public Builder idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = Optional.ofNullable(idempotencyKey);
            return this;
        }

        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public Builder description(Optional<String> description) {
            this.description = description;
            return this;
        }

        public Builder description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        public CreateInvoiceAttachmentRequestData build() {
            return new CreateInvoiceAttachmentRequestData(this.idempotencyKey, this.description, this.additionalProperties);
        }
    }
}

