/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Error;
import com.squareup.square.types.GiftCard;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateGiftCardResponse {
    private final Optional<List<Error>> errors;
    private final Optional<GiftCard> giftCard;
    private final Map<String, Object> additionalProperties;

    private CreateGiftCardResponse(Optional<List<Error>> errors, Optional<GiftCard> giftCard, Map<String, Object> additionalProperties) {
        this.errors = errors;
        this.giftCard = giftCard;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="gift_card")
    public Optional<GiftCard> getGiftCard() {
        return this.giftCard;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateGiftCardResponse && this.equalTo((CreateGiftCardResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateGiftCardResponse other) {
        return this.errors.equals(other.errors) && this.giftCard.equals(other.giftCard);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.giftCard);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Error>> errors = Optional.empty();
        private Optional<GiftCard> giftCard = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CreateGiftCardResponse other) {
            this.errors(other.getErrors());
            this.giftCard(other.getGiftCard());
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        @JsonSetter(value="gift_card", nulls=Nulls.SKIP)
        public Builder giftCard(Optional<GiftCard> giftCard) {
            this.giftCard = giftCard;
            return this;
        }

        public Builder giftCard(GiftCard giftCard) {
            this.giftCard = Optional.ofNullable(giftCard);
            return this;
        }

        public CreateGiftCardResponse build() {
            return new CreateGiftCardResponse(this.errors, this.giftCard, this.additionalProperties);
        }
    }
}

