/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.GiftCard;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateGiftCardRequest {
    private final String idempotencyKey;
    private final String locationId;
    private final GiftCard giftCard;
    private final Map<String, Object> additionalProperties;

    private CreateGiftCardRequest(String idempotencyKey, String locationId, GiftCard giftCard, Map<String, Object> additionalProperties) {
        this.idempotencyKey = idempotencyKey;
        this.locationId = locationId;
        this.giftCard = giftCard;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="idempotency_key")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonProperty(value="location_id")
    public String getLocationId() {
        return this.locationId;
    }

    @JsonProperty(value="gift_card")
    public GiftCard getGiftCard() {
        return this.giftCard;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateGiftCardRequest && this.equalTo((CreateGiftCardRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateGiftCardRequest other) {
        return this.idempotencyKey.equals(other.idempotencyKey) && this.locationId.equals(other.locationId) && this.giftCard.equals(other.giftCard);
    }

    public int hashCode() {
        return Objects.hash(this.idempotencyKey, this.locationId, this.giftCard);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdempotencyKeyStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdempotencyKeyStage,
    LocationIdStage,
    GiftCardStage,
    _FinalStage {
        private String idempotencyKey;
        private String locationId;
        private GiftCard giftCard;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateGiftCardRequest other) {
            this.idempotencyKey(other.getIdempotencyKey());
            this.locationId(other.getLocationId());
            this.giftCard(other.getGiftCard());
            return this;
        }

        @Override
        @JsonSetter(value="idempotency_key")
        public LocationIdStage idempotencyKey(@NotNull String idempotencyKey) {
            this.idempotencyKey = Objects.requireNonNull(idempotencyKey, "idempotencyKey must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="location_id")
        public GiftCardStage locationId(@NotNull String locationId) {
            this.locationId = Objects.requireNonNull(locationId, "locationId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="gift_card")
        public _FinalStage giftCard(@NotNull GiftCard giftCard) {
            this.giftCard = Objects.requireNonNull(giftCard, "giftCard must not be null");
            return this;
        }

        @Override
        public CreateGiftCardRequest build() {
            return new CreateGiftCardRequest(this.idempotencyKey, this.locationId, this.giftCard, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateGiftCardRequest build();
    }

    public static interface GiftCardStage {
        public _FinalStage giftCard(@NotNull GiftCard var1);
    }

    public static interface LocationIdStage {
        public GiftCardStage locationId(@NotNull String var1);
    }

    public static interface IdempotencyKeyStage {
        public LocationIdStage idempotencyKey(@NotNull String var1);

        public Builder from(CreateGiftCardRequest var1);
    }
}

