/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Checkout;
import com.squareup.square.types.Error;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateCheckoutResponse {
    private final Optional<Checkout> checkout;
    private final Optional<List<Error>> errors;
    private final Map<String, Object> additionalProperties;

    private CreateCheckoutResponse(Optional<Checkout> checkout, Optional<List<Error>> errors, Map<String, Object> additionalProperties) {
        this.checkout = checkout;
        this.errors = errors;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="checkout")
    public Optional<Checkout> getCheckout() {
        return this.checkout;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateCheckoutResponse && this.equalTo((CreateCheckoutResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateCheckoutResponse other) {
        return this.checkout.equals(other.checkout) && this.errors.equals(other.errors);
    }

    public int hashCode() {
        return Objects.hash(this.checkout, this.errors);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Checkout> checkout = Optional.empty();
        private Optional<List<Error>> errors = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CreateCheckoutResponse other) {
            this.checkout(other.getCheckout());
            this.errors(other.getErrors());
            return this;
        }

        @JsonSetter(value="checkout", nulls=Nulls.SKIP)
        public Builder checkout(Optional<Checkout> checkout) {
            this.checkout = checkout;
            return this;
        }

        public Builder checkout(Checkout checkout) {
            this.checkout = Optional.ofNullable(checkout);
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        public CreateCheckoutResponse build() {
            return new CreateCheckoutResponse(this.checkout, this.errors, this.additionalProperties);
        }
    }
}

