/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Address;
import com.squareup.square.types.ChargeRequestAdditionalRecipient;
import com.squareup.square.types.CreateOrderRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateCheckoutRequest {
    private final String locationId;
    private final String idempotencyKey;
    private final CreateOrderRequest order;
    private final Optional<Boolean> askForShippingAddress;
    private final Optional<String> merchantSupportEmail;
    private final Optional<String> prePopulateBuyerEmail;
    private final Optional<Address> prePopulateShippingAddress;
    private final Optional<String> redirectUrl;
    private final Optional<List<ChargeRequestAdditionalRecipient>> additionalRecipients;
    private final Optional<String> note;
    private final Map<String, Object> additionalProperties;

    private CreateCheckoutRequest(String locationId, String idempotencyKey, CreateOrderRequest order, Optional<Boolean> askForShippingAddress, Optional<String> merchantSupportEmail, Optional<String> prePopulateBuyerEmail, Optional<Address> prePopulateShippingAddress, Optional<String> redirectUrl, Optional<List<ChargeRequestAdditionalRecipient>> additionalRecipients, Optional<String> note, Map<String, Object> additionalProperties) {
        this.locationId = locationId;
        this.idempotencyKey = idempotencyKey;
        this.order = order;
        this.askForShippingAddress = askForShippingAddress;
        this.merchantSupportEmail = merchantSupportEmail;
        this.prePopulateBuyerEmail = prePopulateBuyerEmail;
        this.prePopulateShippingAddress = prePopulateShippingAddress;
        this.redirectUrl = redirectUrl;
        this.additionalRecipients = additionalRecipients;
        this.note = note;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="location_id")
    public String getLocationId() {
        return this.locationId;
    }

    @JsonProperty(value="idempotency_key")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonProperty(value="order")
    public CreateOrderRequest getOrder() {
        return this.order;
    }

    @JsonProperty(value="ask_for_shipping_address")
    public Optional<Boolean> getAskForShippingAddress() {
        return this.askForShippingAddress;
    }

    @JsonProperty(value="merchant_support_email")
    public Optional<String> getMerchantSupportEmail() {
        return this.merchantSupportEmail;
    }

    @JsonProperty(value="pre_populate_buyer_email")
    public Optional<String> getPrePopulateBuyerEmail() {
        return this.prePopulateBuyerEmail;
    }

    @JsonProperty(value="pre_populate_shipping_address")
    public Optional<Address> getPrePopulateShippingAddress() {
        return this.prePopulateShippingAddress;
    }

    @JsonProperty(value="redirect_url")
    public Optional<String> getRedirectUrl() {
        return this.redirectUrl;
    }

    @JsonProperty(value="additional_recipients")
    public Optional<List<ChargeRequestAdditionalRecipient>> getAdditionalRecipients() {
        return this.additionalRecipients;
    }

    @JsonProperty(value="note")
    public Optional<String> getNote() {
        return this.note;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateCheckoutRequest && this.equalTo((CreateCheckoutRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateCheckoutRequest other) {
        return this.locationId.equals(other.locationId) && this.idempotencyKey.equals(other.idempotencyKey) && this.order.equals(other.order) && this.askForShippingAddress.equals(other.askForShippingAddress) && this.merchantSupportEmail.equals(other.merchantSupportEmail) && this.prePopulateBuyerEmail.equals(other.prePopulateBuyerEmail) && this.prePopulateShippingAddress.equals(other.prePopulateShippingAddress) && this.redirectUrl.equals(other.redirectUrl) && this.additionalRecipients.equals(other.additionalRecipients) && this.note.equals(other.note);
    }

    public int hashCode() {
        return Objects.hash(this.locationId, this.idempotencyKey, this.order, this.askForShippingAddress, this.merchantSupportEmail, this.prePopulateBuyerEmail, this.prePopulateShippingAddress, this.redirectUrl, this.additionalRecipients, this.note);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static LocationIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements LocationIdStage,
    IdempotencyKeyStage,
    OrderStage,
    _FinalStage {
        private String locationId;
        private String idempotencyKey;
        private CreateOrderRequest order;
        private Optional<String> note = Optional.empty();
        private Optional<List<ChargeRequestAdditionalRecipient>> additionalRecipients = Optional.empty();
        private Optional<String> redirectUrl = Optional.empty();
        private Optional<Address> prePopulateShippingAddress = Optional.empty();
        private Optional<String> prePopulateBuyerEmail = Optional.empty();
        private Optional<String> merchantSupportEmail = Optional.empty();
        private Optional<Boolean> askForShippingAddress = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateCheckoutRequest other) {
            this.locationId(other.getLocationId());
            this.idempotencyKey(other.getIdempotencyKey());
            this.order(other.getOrder());
            this.askForShippingAddress(other.getAskForShippingAddress());
            this.merchantSupportEmail(other.getMerchantSupportEmail());
            this.prePopulateBuyerEmail(other.getPrePopulateBuyerEmail());
            this.prePopulateShippingAddress(other.getPrePopulateShippingAddress());
            this.redirectUrl(other.getRedirectUrl());
            this.additionalRecipients(other.getAdditionalRecipients());
            this.note(other.getNote());
            return this;
        }

        @Override
        @JsonSetter(value="location_id")
        public IdempotencyKeyStage locationId(@NotNull String locationId) {
            this.locationId = Objects.requireNonNull(locationId, "locationId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="idempotency_key")
        public OrderStage idempotencyKey(@NotNull String idempotencyKey) {
            this.idempotencyKey = Objects.requireNonNull(idempotencyKey, "idempotencyKey must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="order")
        public _FinalStage order(@NotNull CreateOrderRequest order) {
            this.order = Objects.requireNonNull(order, "order must not be null");
            return this;
        }

        @Override
        public _FinalStage note(String note) {
            this.note = Optional.ofNullable(note);
            return this;
        }

        @Override
        @JsonSetter(value="note", nulls=Nulls.SKIP)
        public _FinalStage note(Optional<String> note) {
            this.note = note;
            return this;
        }

        @Override
        public _FinalStage additionalRecipients(List<ChargeRequestAdditionalRecipient> additionalRecipients) {
            this.additionalRecipients = Optional.ofNullable(additionalRecipients);
            return this;
        }

        @Override
        @JsonSetter(value="additional_recipients", nulls=Nulls.SKIP)
        public _FinalStage additionalRecipients(Optional<List<ChargeRequestAdditionalRecipient>> additionalRecipients) {
            this.additionalRecipients = additionalRecipients;
            return this;
        }

        @Override
        public _FinalStage redirectUrl(String redirectUrl) {
            this.redirectUrl = Optional.ofNullable(redirectUrl);
            return this;
        }

        @Override
        @JsonSetter(value="redirect_url", nulls=Nulls.SKIP)
        public _FinalStage redirectUrl(Optional<String> redirectUrl) {
            this.redirectUrl = redirectUrl;
            return this;
        }

        @Override
        public _FinalStage prePopulateShippingAddress(Address prePopulateShippingAddress) {
            this.prePopulateShippingAddress = Optional.ofNullable(prePopulateShippingAddress);
            return this;
        }

        @Override
        @JsonSetter(value="pre_populate_shipping_address", nulls=Nulls.SKIP)
        public _FinalStage prePopulateShippingAddress(Optional<Address> prePopulateShippingAddress) {
            this.prePopulateShippingAddress = prePopulateShippingAddress;
            return this;
        }

        @Override
        public _FinalStage prePopulateBuyerEmail(String prePopulateBuyerEmail) {
            this.prePopulateBuyerEmail = Optional.ofNullable(prePopulateBuyerEmail);
            return this;
        }

        @Override
        @JsonSetter(value="pre_populate_buyer_email", nulls=Nulls.SKIP)
        public _FinalStage prePopulateBuyerEmail(Optional<String> prePopulateBuyerEmail) {
            this.prePopulateBuyerEmail = prePopulateBuyerEmail;
            return this;
        }

        @Override
        public _FinalStage merchantSupportEmail(String merchantSupportEmail) {
            this.merchantSupportEmail = Optional.ofNullable(merchantSupportEmail);
            return this;
        }

        @Override
        @JsonSetter(value="merchant_support_email", nulls=Nulls.SKIP)
        public _FinalStage merchantSupportEmail(Optional<String> merchantSupportEmail) {
            this.merchantSupportEmail = merchantSupportEmail;
            return this;
        }

        @Override
        public _FinalStage askForShippingAddress(Boolean askForShippingAddress) {
            this.askForShippingAddress = Optional.ofNullable(askForShippingAddress);
            return this;
        }

        @Override
        @JsonSetter(value="ask_for_shipping_address", nulls=Nulls.SKIP)
        public _FinalStage askForShippingAddress(Optional<Boolean> askForShippingAddress) {
            this.askForShippingAddress = askForShippingAddress;
            return this;
        }

        @Override
        public CreateCheckoutRequest build() {
            return new CreateCheckoutRequest(this.locationId, this.idempotencyKey, this.order, this.askForShippingAddress, this.merchantSupportEmail, this.prePopulateBuyerEmail, this.prePopulateShippingAddress, this.redirectUrl, this.additionalRecipients, this.note, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateCheckoutRequest build();

        public _FinalStage askForShippingAddress(Optional<Boolean> var1);

        public _FinalStage askForShippingAddress(Boolean var1);

        public _FinalStage merchantSupportEmail(Optional<String> var1);

        public _FinalStage merchantSupportEmail(String var1);

        public _FinalStage prePopulateBuyerEmail(Optional<String> var1);

        public _FinalStage prePopulateBuyerEmail(String var1);

        public _FinalStage prePopulateShippingAddress(Optional<Address> var1);

        public _FinalStage prePopulateShippingAddress(Address var1);

        public _FinalStage redirectUrl(Optional<String> var1);

        public _FinalStage redirectUrl(String var1);

        public _FinalStage additionalRecipients(Optional<List<ChargeRequestAdditionalRecipient>> var1);

        public _FinalStage additionalRecipients(List<ChargeRequestAdditionalRecipient> var1);

        public _FinalStage note(Optional<String> var1);

        public _FinalStage note(String var1);
    }

    public static interface OrderStage {
        public _FinalStage order(@NotNull CreateOrderRequest var1);
    }

    public static interface IdempotencyKeyStage {
        public OrderStage idempotencyKey(@NotNull String var1);
    }

    public static interface LocationIdStage {
        public IdempotencyKeyStage locationId(@NotNull String var1);

        public Builder from(CreateCheckoutRequest var1);
    }
}

