/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CatalogObject;
import com.squareup.square.types.Error;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateCatalogImageResponse {
    private final Optional<List<Error>> errors;
    private final Optional<CatalogObject> image;
    private final Map<String, Object> additionalProperties;

    private CreateCatalogImageResponse(Optional<List<Error>> errors, Optional<CatalogObject> image, Map<String, Object> additionalProperties) {
        this.errors = errors;
        this.image = image;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="image")
    public Optional<CatalogObject> getImage() {
        return this.image;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateCatalogImageResponse && this.equalTo((CreateCatalogImageResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateCatalogImageResponse other) {
        return this.errors.equals(other.errors) && this.image.equals(other.image);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.image);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Error>> errors = Optional.empty();
        private Optional<CatalogObject> image = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CreateCatalogImageResponse other) {
            this.errors(other.getErrors());
            this.image(other.getImage());
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        @JsonSetter(value="image", nulls=Nulls.SKIP)
        public Builder image(Optional<CatalogObject> image) {
            this.image = image;
            return this;
        }

        public Builder image(CatalogObject image) {
            this.image = Optional.ofNullable(image);
            return this;
        }

        public CreateCatalogImageResponse build() {
            return new CreateCatalogImageResponse(this.errors, this.image, this.additionalProperties);
        }
    }
}

