/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Card;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateCardRequest {
    private final String idempotencyKey;
    private final String sourceId;
    private final Optional<String> verificationToken;
    private final Card card;
    private final Map<String, Object> additionalProperties;

    private CreateCardRequest(String idempotencyKey, String sourceId, Optional<String> verificationToken, Card card, Map<String, Object> additionalProperties) {
        this.idempotencyKey = idempotencyKey;
        this.sourceId = sourceId;
        this.verificationToken = verificationToken;
        this.card = card;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="idempotency_key")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonProperty(value="source_id")
    public String getSourceId() {
        return this.sourceId;
    }

    @JsonProperty(value="verification_token")
    public Optional<String> getVerificationToken() {
        return this.verificationToken;
    }

    @JsonProperty(value="card")
    public Card getCard() {
        return this.card;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateCardRequest && this.equalTo((CreateCardRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateCardRequest other) {
        return this.idempotencyKey.equals(other.idempotencyKey) && this.sourceId.equals(other.sourceId) && this.verificationToken.equals(other.verificationToken) && this.card.equals(other.card);
    }

    public int hashCode() {
        return Objects.hash(this.idempotencyKey, this.sourceId, this.verificationToken, this.card);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdempotencyKeyStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdempotencyKeyStage,
    SourceIdStage,
    CardStage,
    _FinalStage {
        private String idempotencyKey;
        private String sourceId;
        private Card card;
        private Optional<String> verificationToken = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateCardRequest other) {
            this.idempotencyKey(other.getIdempotencyKey());
            this.sourceId(other.getSourceId());
            this.verificationToken(other.getVerificationToken());
            this.card(other.getCard());
            return this;
        }

        @Override
        @JsonSetter(value="idempotency_key")
        public SourceIdStage idempotencyKey(@NotNull String idempotencyKey) {
            this.idempotencyKey = Objects.requireNonNull(idempotencyKey, "idempotencyKey must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="source_id")
        public CardStage sourceId(@NotNull String sourceId) {
            this.sourceId = Objects.requireNonNull(sourceId, "sourceId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="card")
        public _FinalStage card(@NotNull Card card) {
            this.card = Objects.requireNonNull(card, "card must not be null");
            return this;
        }

        @Override
        public _FinalStage verificationToken(String verificationToken) {
            this.verificationToken = Optional.ofNullable(verificationToken);
            return this;
        }

        @Override
        @JsonSetter(value="verification_token", nulls=Nulls.SKIP)
        public _FinalStage verificationToken(Optional<String> verificationToken) {
            this.verificationToken = verificationToken;
            return this;
        }

        @Override
        public CreateCardRequest build() {
            return new CreateCardRequest(this.idempotencyKey, this.sourceId, this.verificationToken, this.card, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateCardRequest build();

        public _FinalStage verificationToken(Optional<String> var1);

        public _FinalStage verificationToken(String var1);
    }

    public static interface CardStage {
        public _FinalStage card(@NotNull Card var1);
    }

    public static interface SourceIdStage {
        public CardStage sourceId(@NotNull String var1);
    }

    public static interface IdempotencyKeyStage {
        public SourceIdStage idempotencyKey(@NotNull String var1);

        public Builder from(CreateCardRequest var1);
    }
}

