/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.ComponentComponentType;
import com.squareup.square.types.DeviceComponentDetailsApplicationDetails;
import com.squareup.square.types.DeviceComponentDetailsBatteryDetails;
import com.squareup.square.types.DeviceComponentDetailsCardReaderDetails;
import com.squareup.square.types.DeviceComponentDetailsEthernetDetails;
import com.squareup.square.types.DeviceComponentDetailsWiFiDetails;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Component {
    private final ComponentComponentType type;
    private final Optional<DeviceComponentDetailsApplicationDetails> applicationDetails;
    private final Optional<DeviceComponentDetailsCardReaderDetails> cardReaderDetails;
    private final Optional<DeviceComponentDetailsBatteryDetails> batteryDetails;
    private final Optional<DeviceComponentDetailsWiFiDetails> wifiDetails;
    private final Optional<DeviceComponentDetailsEthernetDetails> ethernetDetails;
    private final Map<String, Object> additionalProperties;

    private Component(ComponentComponentType type, Optional<DeviceComponentDetailsApplicationDetails> applicationDetails, Optional<DeviceComponentDetailsCardReaderDetails> cardReaderDetails, Optional<DeviceComponentDetailsBatteryDetails> batteryDetails, Optional<DeviceComponentDetailsWiFiDetails> wifiDetails, Optional<DeviceComponentDetailsEthernetDetails> ethernetDetails, Map<String, Object> additionalProperties) {
        this.type = type;
        this.applicationDetails = applicationDetails;
        this.cardReaderDetails = cardReaderDetails;
        this.batteryDetails = batteryDetails;
        this.wifiDetails = wifiDetails;
        this.ethernetDetails = ethernetDetails;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public ComponentComponentType getType() {
        return this.type;
    }

    @JsonProperty(value="application_details")
    public Optional<DeviceComponentDetailsApplicationDetails> getApplicationDetails() {
        return this.applicationDetails;
    }

    @JsonProperty(value="card_reader_details")
    public Optional<DeviceComponentDetailsCardReaderDetails> getCardReaderDetails() {
        return this.cardReaderDetails;
    }

    @JsonProperty(value="battery_details")
    public Optional<DeviceComponentDetailsBatteryDetails> getBatteryDetails() {
        return this.batteryDetails;
    }

    @JsonProperty(value="wifi_details")
    public Optional<DeviceComponentDetailsWiFiDetails> getWifiDetails() {
        return this.wifiDetails;
    }

    @JsonProperty(value="ethernet_details")
    public Optional<DeviceComponentDetailsEthernetDetails> getEthernetDetails() {
        return this.ethernetDetails;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Component && this.equalTo((Component)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Component other) {
        return this.type.equals(other.type) && this.applicationDetails.equals(other.applicationDetails) && this.cardReaderDetails.equals(other.cardReaderDetails) && this.batteryDetails.equals(other.batteryDetails) && this.wifiDetails.equals(other.wifiDetails) && this.ethernetDetails.equals(other.ethernetDetails);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.applicationDetails, this.cardReaderDetails, this.batteryDetails, this.wifiDetails, this.ethernetDetails);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TypeStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TypeStage,
    _FinalStage {
        private ComponentComponentType type;
        private Optional<DeviceComponentDetailsEthernetDetails> ethernetDetails = Optional.empty();
        private Optional<DeviceComponentDetailsWiFiDetails> wifiDetails = Optional.empty();
        private Optional<DeviceComponentDetailsBatteryDetails> batteryDetails = Optional.empty();
        private Optional<DeviceComponentDetailsCardReaderDetails> cardReaderDetails = Optional.empty();
        private Optional<DeviceComponentDetailsApplicationDetails> applicationDetails = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(Component other) {
            this.type(other.getType());
            this.applicationDetails(other.getApplicationDetails());
            this.cardReaderDetails(other.getCardReaderDetails());
            this.batteryDetails(other.getBatteryDetails());
            this.wifiDetails(other.getWifiDetails());
            this.ethernetDetails(other.getEthernetDetails());
            return this;
        }

        @Override
        @JsonSetter(value="type")
        public _FinalStage type(@NotNull ComponentComponentType type) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            return this;
        }

        @Override
        public _FinalStage ethernetDetails(DeviceComponentDetailsEthernetDetails ethernetDetails) {
            this.ethernetDetails = Optional.ofNullable(ethernetDetails);
            return this;
        }

        @Override
        @JsonSetter(value="ethernet_details", nulls=Nulls.SKIP)
        public _FinalStage ethernetDetails(Optional<DeviceComponentDetailsEthernetDetails> ethernetDetails) {
            this.ethernetDetails = ethernetDetails;
            return this;
        }

        @Override
        public _FinalStage wifiDetails(DeviceComponentDetailsWiFiDetails wifiDetails) {
            this.wifiDetails = Optional.ofNullable(wifiDetails);
            return this;
        }

        @Override
        @JsonSetter(value="wifi_details", nulls=Nulls.SKIP)
        public _FinalStage wifiDetails(Optional<DeviceComponentDetailsWiFiDetails> wifiDetails) {
            this.wifiDetails = wifiDetails;
            return this;
        }

        @Override
        public _FinalStage batteryDetails(DeviceComponentDetailsBatteryDetails batteryDetails) {
            this.batteryDetails = Optional.ofNullable(batteryDetails);
            return this;
        }

        @Override
        @JsonSetter(value="battery_details", nulls=Nulls.SKIP)
        public _FinalStage batteryDetails(Optional<DeviceComponentDetailsBatteryDetails> batteryDetails) {
            this.batteryDetails = batteryDetails;
            return this;
        }

        @Override
        public _FinalStage cardReaderDetails(DeviceComponentDetailsCardReaderDetails cardReaderDetails) {
            this.cardReaderDetails = Optional.ofNullable(cardReaderDetails);
            return this;
        }

        @Override
        @JsonSetter(value="card_reader_details", nulls=Nulls.SKIP)
        public _FinalStage cardReaderDetails(Optional<DeviceComponentDetailsCardReaderDetails> cardReaderDetails) {
            this.cardReaderDetails = cardReaderDetails;
            return this;
        }

        @Override
        public _FinalStage applicationDetails(DeviceComponentDetailsApplicationDetails applicationDetails) {
            this.applicationDetails = Optional.ofNullable(applicationDetails);
            return this;
        }

        @Override
        @JsonSetter(value="application_details", nulls=Nulls.SKIP)
        public _FinalStage applicationDetails(Optional<DeviceComponentDetailsApplicationDetails> applicationDetails) {
            this.applicationDetails = applicationDetails;
            return this;
        }

        @Override
        public Component build() {
            return new Component(this.type, this.applicationDetails, this.cardReaderDetails, this.batteryDetails, this.wifiDetails, this.ethernetDetails, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public Component build();

        public _FinalStage applicationDetails(Optional<DeviceComponentDetailsApplicationDetails> var1);

        public _FinalStage applicationDetails(DeviceComponentDetailsApplicationDetails var1);

        public _FinalStage cardReaderDetails(Optional<DeviceComponentDetailsCardReaderDetails> var1);

        public _FinalStage cardReaderDetails(DeviceComponentDetailsCardReaderDetails var1);

        public _FinalStage batteryDetails(Optional<DeviceComponentDetailsBatteryDetails> var1);

        public _FinalStage batteryDetails(DeviceComponentDetailsBatteryDetails var1);

        public _FinalStage wifiDetails(Optional<DeviceComponentDetailsWiFiDetails> var1);

        public _FinalStage wifiDetails(DeviceComponentDetailsWiFiDetails var1);

        public _FinalStage ethernetDetails(Optional<DeviceComponentDetailsEthernetDetails> var1);

        public _FinalStage ethernetDetails(DeviceComponentDetailsEthernetDetails var1);
    }

    public static interface TypeStage {
        public _FinalStage type(@NotNull ComponentComponentType var1);

        public Builder from(Component var1);
    }
}

