/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CollectedData {
    private final Optional<String> inputText;
    private final Map<String, Object> additionalProperties;

    private CollectedData(Optional<String> inputText, Map<String, Object> additionalProperties) {
        this.inputText = inputText;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="input_text")
    public Optional<String> getInputText() {
        return this.inputText;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CollectedData && this.equalTo((CollectedData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CollectedData other) {
        return this.inputText.equals(other.inputText);
    }

    public int hashCode() {
        return Objects.hash(this.inputText);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> inputText = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CollectedData other) {
            this.inputText(other.getInputText());
            return this;
        }

        @JsonSetter(value="input_text", nulls=Nulls.SKIP)
        public Builder inputText(Optional<String> inputText) {
            this.inputText = inputText;
            return this;
        }

        public Builder inputText(String inputText) {
            this.inputText = Optional.ofNullable(inputText);
            return this;
        }

        public CollectedData build() {
            return new CollectedData(this.inputText, this.additionalProperties);
        }
    }
}

