/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Money;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CheckoutLocationSettingsTipping {
    private final Optional<List<Integer>> percentages;
    private final Optional<Boolean> smartTippingEnabled;
    private final Optional<Integer> defaultPercent;
    private final Optional<List<Money>> smartTips;
    private final Optional<Money> defaultSmartTip;
    private final Map<String, Object> additionalProperties;

    private CheckoutLocationSettingsTipping(Optional<List<Integer>> percentages, Optional<Boolean> smartTippingEnabled, Optional<Integer> defaultPercent, Optional<List<Money>> smartTips, Optional<Money> defaultSmartTip, Map<String, Object> additionalProperties) {
        this.percentages = percentages;
        this.smartTippingEnabled = smartTippingEnabled;
        this.defaultPercent = defaultPercent;
        this.smartTips = smartTips;
        this.defaultSmartTip = defaultSmartTip;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<List<Integer>> getPercentages() {
        if (this.percentages == null) {
            return Optional.empty();
        }
        return this.percentages;
    }

    @JsonIgnore
    public Optional<Boolean> getSmartTippingEnabled() {
        if (this.smartTippingEnabled == null) {
            return Optional.empty();
        }
        return this.smartTippingEnabled;
    }

    @JsonIgnore
    public Optional<Integer> getDefaultPercent() {
        if (this.defaultPercent == null) {
            return Optional.empty();
        }
        return this.defaultPercent;
    }

    @JsonIgnore
    public Optional<List<Money>> getSmartTips() {
        if (this.smartTips == null) {
            return Optional.empty();
        }
        return this.smartTips;
    }

    @JsonProperty(value="default_smart_tip")
    public Optional<Money> getDefaultSmartTip() {
        return this.defaultSmartTip;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="percentages")
    private Optional<List<Integer>> _getPercentages() {
        return this.percentages;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="smart_tipping_enabled")
    private Optional<Boolean> _getSmartTippingEnabled() {
        return this.smartTippingEnabled;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="default_percent")
    private Optional<Integer> _getDefaultPercent() {
        return this.defaultPercent;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="smart_tips")
    private Optional<List<Money>> _getSmartTips() {
        return this.smartTips;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CheckoutLocationSettingsTipping && this.equalTo((CheckoutLocationSettingsTipping)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CheckoutLocationSettingsTipping other) {
        return this.percentages.equals(other.percentages) && this.smartTippingEnabled.equals(other.smartTippingEnabled) && this.defaultPercent.equals(other.defaultPercent) && this.smartTips.equals(other.smartTips) && this.defaultSmartTip.equals(other.defaultSmartTip);
    }

    public int hashCode() {
        return Objects.hash(this.percentages, this.smartTippingEnabled, this.defaultPercent, this.smartTips, this.defaultSmartTip);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Integer>> percentages = Optional.empty();
        private Optional<Boolean> smartTippingEnabled = Optional.empty();
        private Optional<Integer> defaultPercent = Optional.empty();
        private Optional<List<Money>> smartTips = Optional.empty();
        private Optional<Money> defaultSmartTip = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CheckoutLocationSettingsTipping other) {
            this.percentages(other.getPercentages());
            this.smartTippingEnabled(other.getSmartTippingEnabled());
            this.defaultPercent(other.getDefaultPercent());
            this.smartTips(other.getSmartTips());
            this.defaultSmartTip(other.getDefaultSmartTip());
            return this;
        }

        @JsonSetter(value="percentages", nulls=Nulls.SKIP)
        public Builder percentages(Optional<List<Integer>> percentages) {
            this.percentages = percentages;
            return this;
        }

        public Builder percentages(List<Integer> percentages) {
            this.percentages = Optional.ofNullable(percentages);
            return this;
        }

        public Builder percentages(Nullable<List<Integer>> percentages) {
            this.percentages = percentages.isNull() ? null : (percentages.isEmpty() ? Optional.empty() : Optional.of(percentages.get()));
            return this;
        }

        @JsonSetter(value="smart_tipping_enabled", nulls=Nulls.SKIP)
        public Builder smartTippingEnabled(Optional<Boolean> smartTippingEnabled) {
            this.smartTippingEnabled = smartTippingEnabled;
            return this;
        }

        public Builder smartTippingEnabled(Boolean smartTippingEnabled) {
            this.smartTippingEnabled = Optional.ofNullable(smartTippingEnabled);
            return this;
        }

        public Builder smartTippingEnabled(Nullable<Boolean> smartTippingEnabled) {
            this.smartTippingEnabled = smartTippingEnabled.isNull() ? null : (smartTippingEnabled.isEmpty() ? Optional.empty() : Optional.of(smartTippingEnabled.get()));
            return this;
        }

        @JsonSetter(value="default_percent", nulls=Nulls.SKIP)
        public Builder defaultPercent(Optional<Integer> defaultPercent) {
            this.defaultPercent = defaultPercent;
            return this;
        }

        public Builder defaultPercent(Integer defaultPercent) {
            this.defaultPercent = Optional.ofNullable(defaultPercent);
            return this;
        }

        public Builder defaultPercent(Nullable<Integer> defaultPercent) {
            this.defaultPercent = defaultPercent.isNull() ? null : (defaultPercent.isEmpty() ? Optional.empty() : Optional.of(defaultPercent.get()));
            return this;
        }

        @JsonSetter(value="smart_tips", nulls=Nulls.SKIP)
        public Builder smartTips(Optional<List<Money>> smartTips) {
            this.smartTips = smartTips;
            return this;
        }

        public Builder smartTips(List<Money> smartTips) {
            this.smartTips = Optional.ofNullable(smartTips);
            return this;
        }

        public Builder smartTips(Nullable<List<Money>> smartTips) {
            this.smartTips = smartTips.isNull() ? null : (smartTips.isEmpty() ? Optional.empty() : Optional.of(smartTips.get()));
            return this;
        }

        @JsonSetter(value="default_smart_tip", nulls=Nulls.SKIP)
        public Builder defaultSmartTip(Optional<Money> defaultSmartTip) {
            this.defaultSmartTip = defaultSmartTip;
            return this;
        }

        public Builder defaultSmartTip(Money defaultSmartTip) {
            this.defaultSmartTip = Optional.ofNullable(defaultSmartTip);
            return this;
        }

        public CheckoutLocationSettingsTipping build() {
            return new CheckoutLocationSettingsTipping(this.percentages, this.smartTippingEnabled, this.defaultPercent, this.smartTips, this.defaultSmartTip, this.additionalProperties);
        }
    }
}

