/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CheckoutLocationSettingsBrandingButtonShape;
import com.squareup.square.types.CheckoutLocationSettingsBrandingHeaderType;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CheckoutLocationSettingsBranding {
    private final Optional<CheckoutLocationSettingsBrandingHeaderType> headerType;
    private final Optional<String> buttonColor;
    private final Optional<CheckoutLocationSettingsBrandingButtonShape> buttonShape;
    private final Map<String, Object> additionalProperties;

    private CheckoutLocationSettingsBranding(Optional<CheckoutLocationSettingsBrandingHeaderType> headerType, Optional<String> buttonColor, Optional<CheckoutLocationSettingsBrandingButtonShape> buttonShape, Map<String, Object> additionalProperties) {
        this.headerType = headerType;
        this.buttonColor = buttonColor;
        this.buttonShape = buttonShape;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="header_type")
    public Optional<CheckoutLocationSettingsBrandingHeaderType> getHeaderType() {
        return this.headerType;
    }

    @JsonIgnore
    public Optional<String> getButtonColor() {
        if (this.buttonColor == null) {
            return Optional.empty();
        }
        return this.buttonColor;
    }

    @JsonProperty(value="button_shape")
    public Optional<CheckoutLocationSettingsBrandingButtonShape> getButtonShape() {
        return this.buttonShape;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="button_color")
    private Optional<String> _getButtonColor() {
        return this.buttonColor;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CheckoutLocationSettingsBranding && this.equalTo((CheckoutLocationSettingsBranding)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CheckoutLocationSettingsBranding other) {
        return this.headerType.equals(other.headerType) && this.buttonColor.equals(other.buttonColor) && this.buttonShape.equals(other.buttonShape);
    }

    public int hashCode() {
        return Objects.hash(this.headerType, this.buttonColor, this.buttonShape);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<CheckoutLocationSettingsBrandingHeaderType> headerType = Optional.empty();
        private Optional<String> buttonColor = Optional.empty();
        private Optional<CheckoutLocationSettingsBrandingButtonShape> buttonShape = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CheckoutLocationSettingsBranding other) {
            this.headerType(other.getHeaderType());
            this.buttonColor(other.getButtonColor());
            this.buttonShape(other.getButtonShape());
            return this;
        }

        @JsonSetter(value="header_type", nulls=Nulls.SKIP)
        public Builder headerType(Optional<CheckoutLocationSettingsBrandingHeaderType> headerType) {
            this.headerType = headerType;
            return this;
        }

        public Builder headerType(CheckoutLocationSettingsBrandingHeaderType headerType) {
            this.headerType = Optional.ofNullable(headerType);
            return this;
        }

        @JsonSetter(value="button_color", nulls=Nulls.SKIP)
        public Builder buttonColor(Optional<String> buttonColor) {
            this.buttonColor = buttonColor;
            return this;
        }

        public Builder buttonColor(String buttonColor) {
            this.buttonColor = Optional.ofNullable(buttonColor);
            return this;
        }

        public Builder buttonColor(Nullable<String> buttonColor) {
            this.buttonColor = buttonColor.isNull() ? null : (buttonColor.isEmpty() ? Optional.empty() : Optional.of(buttonColor.get()));
            return this;
        }

        @JsonSetter(value="button_shape", nulls=Nulls.SKIP)
        public Builder buttonShape(Optional<CheckoutLocationSettingsBrandingButtonShape> buttonShape) {
            this.buttonShape = buttonShape;
            return this;
        }

        public Builder buttonShape(CheckoutLocationSettingsBrandingButtonShape buttonShape) {
            this.buttonShape = Optional.ofNullable(buttonShape);
            return this;
        }

        public CheckoutLocationSettingsBranding build() {
            return new CheckoutLocationSettingsBranding(this.headerType, this.buttonColor, this.buttonShape, this.additionalProperties);
        }
    }
}

