/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.AdditionalRecipient;
import com.squareup.square.types.Address;
import com.squareup.square.types.Order;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Checkout {
    private final Optional<String> id;
    private final Optional<String> checkoutPageUrl;
    private final Optional<Boolean> askForShippingAddress;
    private final Optional<String> merchantSupportEmail;
    private final Optional<String> prePopulateBuyerEmail;
    private final Optional<Address> prePopulateShippingAddress;
    private final Optional<String> redirectUrl;
    private final Optional<Order> order;
    private final Optional<String> createdAt;
    private final Optional<List<AdditionalRecipient>> additionalRecipients;
    private final Map<String, Object> additionalProperties;

    private Checkout(Optional<String> id, Optional<String> checkoutPageUrl, Optional<Boolean> askForShippingAddress, Optional<String> merchantSupportEmail, Optional<String> prePopulateBuyerEmail, Optional<Address> prePopulateShippingAddress, Optional<String> redirectUrl, Optional<Order> order, Optional<String> createdAt, Optional<List<AdditionalRecipient>> additionalRecipients, Map<String, Object> additionalProperties) {
        this.id = id;
        this.checkoutPageUrl = checkoutPageUrl;
        this.askForShippingAddress = askForShippingAddress;
        this.merchantSupportEmail = merchantSupportEmail;
        this.prePopulateBuyerEmail = prePopulateBuyerEmail;
        this.prePopulateShippingAddress = prePopulateShippingAddress;
        this.redirectUrl = redirectUrl;
        this.order = order;
        this.createdAt = createdAt;
        this.additionalRecipients = additionalRecipients;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonIgnore
    public Optional<String> getCheckoutPageUrl() {
        if (this.checkoutPageUrl == null) {
            return Optional.empty();
        }
        return this.checkoutPageUrl;
    }

    @JsonIgnore
    public Optional<Boolean> getAskForShippingAddress() {
        if (this.askForShippingAddress == null) {
            return Optional.empty();
        }
        return this.askForShippingAddress;
    }

    @JsonIgnore
    public Optional<String> getMerchantSupportEmail() {
        if (this.merchantSupportEmail == null) {
            return Optional.empty();
        }
        return this.merchantSupportEmail;
    }

    @JsonIgnore
    public Optional<String> getPrePopulateBuyerEmail() {
        if (this.prePopulateBuyerEmail == null) {
            return Optional.empty();
        }
        return this.prePopulateBuyerEmail;
    }

    @JsonProperty(value="pre_populate_shipping_address")
    public Optional<Address> getPrePopulateShippingAddress() {
        return this.prePopulateShippingAddress;
    }

    @JsonIgnore
    public Optional<String> getRedirectUrl() {
        if (this.redirectUrl == null) {
            return Optional.empty();
        }
        return this.redirectUrl;
    }

    @JsonProperty(value="order")
    public Optional<Order> getOrder() {
        return this.order;
    }

    @JsonProperty(value="created_at")
    public Optional<String> getCreatedAt() {
        return this.createdAt;
    }

    @JsonIgnore
    public Optional<List<AdditionalRecipient>> getAdditionalRecipients() {
        if (this.additionalRecipients == null) {
            return Optional.empty();
        }
        return this.additionalRecipients;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="checkout_page_url")
    private Optional<String> _getCheckoutPageUrl() {
        return this.checkoutPageUrl;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="ask_for_shipping_address")
    private Optional<Boolean> _getAskForShippingAddress() {
        return this.askForShippingAddress;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="merchant_support_email")
    private Optional<String> _getMerchantSupportEmail() {
        return this.merchantSupportEmail;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="pre_populate_buyer_email")
    private Optional<String> _getPrePopulateBuyerEmail() {
        return this.prePopulateBuyerEmail;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="redirect_url")
    private Optional<String> _getRedirectUrl() {
        return this.redirectUrl;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="additional_recipients")
    private Optional<List<AdditionalRecipient>> _getAdditionalRecipients() {
        return this.additionalRecipients;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Checkout && this.equalTo((Checkout)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Checkout other) {
        return this.id.equals(other.id) && this.checkoutPageUrl.equals(other.checkoutPageUrl) && this.askForShippingAddress.equals(other.askForShippingAddress) && this.merchantSupportEmail.equals(other.merchantSupportEmail) && this.prePopulateBuyerEmail.equals(other.prePopulateBuyerEmail) && this.prePopulateShippingAddress.equals(other.prePopulateShippingAddress) && this.redirectUrl.equals(other.redirectUrl) && this.order.equals(other.order) && this.createdAt.equals(other.createdAt) && this.additionalRecipients.equals(other.additionalRecipients);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.checkoutPageUrl, this.askForShippingAddress, this.merchantSupportEmail, this.prePopulateBuyerEmail, this.prePopulateShippingAddress, this.redirectUrl, this.order, this.createdAt, this.additionalRecipients);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<String> checkoutPageUrl = Optional.empty();
        private Optional<Boolean> askForShippingAddress = Optional.empty();
        private Optional<String> merchantSupportEmail = Optional.empty();
        private Optional<String> prePopulateBuyerEmail = Optional.empty();
        private Optional<Address> prePopulateShippingAddress = Optional.empty();
        private Optional<String> redirectUrl = Optional.empty();
        private Optional<Order> order = Optional.empty();
        private Optional<String> createdAt = Optional.empty();
        private Optional<List<AdditionalRecipient>> additionalRecipients = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(Checkout other) {
            this.id(other.getId());
            this.checkoutPageUrl(other.getCheckoutPageUrl());
            this.askForShippingAddress(other.getAskForShippingAddress());
            this.merchantSupportEmail(other.getMerchantSupportEmail());
            this.prePopulateBuyerEmail(other.getPrePopulateBuyerEmail());
            this.prePopulateShippingAddress(other.getPrePopulateShippingAddress());
            this.redirectUrl(other.getRedirectUrl());
            this.order(other.getOrder());
            this.createdAt(other.getCreatedAt());
            this.additionalRecipients(other.getAdditionalRecipients());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="checkout_page_url", nulls=Nulls.SKIP)
        public Builder checkoutPageUrl(Optional<String> checkoutPageUrl) {
            this.checkoutPageUrl = checkoutPageUrl;
            return this;
        }

        public Builder checkoutPageUrl(String checkoutPageUrl) {
            this.checkoutPageUrl = Optional.ofNullable(checkoutPageUrl);
            return this;
        }

        public Builder checkoutPageUrl(Nullable<String> checkoutPageUrl) {
            this.checkoutPageUrl = checkoutPageUrl.isNull() ? null : (checkoutPageUrl.isEmpty() ? Optional.empty() : Optional.of(checkoutPageUrl.get()));
            return this;
        }

        @JsonSetter(value="ask_for_shipping_address", nulls=Nulls.SKIP)
        public Builder askForShippingAddress(Optional<Boolean> askForShippingAddress) {
            this.askForShippingAddress = askForShippingAddress;
            return this;
        }

        public Builder askForShippingAddress(Boolean askForShippingAddress) {
            this.askForShippingAddress = Optional.ofNullable(askForShippingAddress);
            return this;
        }

        public Builder askForShippingAddress(Nullable<Boolean> askForShippingAddress) {
            this.askForShippingAddress = askForShippingAddress.isNull() ? null : (askForShippingAddress.isEmpty() ? Optional.empty() : Optional.of(askForShippingAddress.get()));
            return this;
        }

        @JsonSetter(value="merchant_support_email", nulls=Nulls.SKIP)
        public Builder merchantSupportEmail(Optional<String> merchantSupportEmail) {
            this.merchantSupportEmail = merchantSupportEmail;
            return this;
        }

        public Builder merchantSupportEmail(String merchantSupportEmail) {
            this.merchantSupportEmail = Optional.ofNullable(merchantSupportEmail);
            return this;
        }

        public Builder merchantSupportEmail(Nullable<String> merchantSupportEmail) {
            this.merchantSupportEmail = merchantSupportEmail.isNull() ? null : (merchantSupportEmail.isEmpty() ? Optional.empty() : Optional.of(merchantSupportEmail.get()));
            return this;
        }

        @JsonSetter(value="pre_populate_buyer_email", nulls=Nulls.SKIP)
        public Builder prePopulateBuyerEmail(Optional<String> prePopulateBuyerEmail) {
            this.prePopulateBuyerEmail = prePopulateBuyerEmail;
            return this;
        }

        public Builder prePopulateBuyerEmail(String prePopulateBuyerEmail) {
            this.prePopulateBuyerEmail = Optional.ofNullable(prePopulateBuyerEmail);
            return this;
        }

        public Builder prePopulateBuyerEmail(Nullable<String> prePopulateBuyerEmail) {
            this.prePopulateBuyerEmail = prePopulateBuyerEmail.isNull() ? null : (prePopulateBuyerEmail.isEmpty() ? Optional.empty() : Optional.of(prePopulateBuyerEmail.get()));
            return this;
        }

        @JsonSetter(value="pre_populate_shipping_address", nulls=Nulls.SKIP)
        public Builder prePopulateShippingAddress(Optional<Address> prePopulateShippingAddress) {
            this.prePopulateShippingAddress = prePopulateShippingAddress;
            return this;
        }

        public Builder prePopulateShippingAddress(Address prePopulateShippingAddress) {
            this.prePopulateShippingAddress = Optional.ofNullable(prePopulateShippingAddress);
            return this;
        }

        @JsonSetter(value="redirect_url", nulls=Nulls.SKIP)
        public Builder redirectUrl(Optional<String> redirectUrl) {
            this.redirectUrl = redirectUrl;
            return this;
        }

        public Builder redirectUrl(String redirectUrl) {
            this.redirectUrl = Optional.ofNullable(redirectUrl);
            return this;
        }

        public Builder redirectUrl(Nullable<String> redirectUrl) {
            this.redirectUrl = redirectUrl.isNull() ? null : (redirectUrl.isEmpty() ? Optional.empty() : Optional.of(redirectUrl.get()));
            return this;
        }

        @JsonSetter(value="order", nulls=Nulls.SKIP)
        public Builder order(Optional<Order> order) {
            this.order = order;
            return this;
        }

        public Builder order(Order order) {
            this.order = Optional.ofNullable(order);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<String> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @JsonSetter(value="additional_recipients", nulls=Nulls.SKIP)
        public Builder additionalRecipients(Optional<List<AdditionalRecipient>> additionalRecipients) {
            this.additionalRecipients = additionalRecipients;
            return this;
        }

        public Builder additionalRecipients(List<AdditionalRecipient> additionalRecipients) {
            this.additionalRecipients = Optional.ofNullable(additionalRecipients);
            return this;
        }

        public Builder additionalRecipients(Nullable<List<AdditionalRecipient>> additionalRecipients) {
            this.additionalRecipients = additionalRecipients.isNull() ? null : (additionalRecipients.isEmpty() ? Optional.empty() : Optional.of(additionalRecipients.get()));
            return this;
        }

        public Checkout build() {
            return new Checkout(this.id, this.checkoutPageUrl, this.askForShippingAddress, this.merchantSupportEmail, this.prePopulateBuyerEmail, this.prePopulateShippingAddress, this.redirectUrl, this.order, this.createdAt, this.additionalRecipients, this.additionalProperties);
        }
    }
}

