/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CategoryPathToRootNode {
    private final Optional<String> categoryId;
    private final Optional<String> categoryName;
    private final Map<String, Object> additionalProperties;

    private CategoryPathToRootNode(Optional<String> categoryId, Optional<String> categoryName, Map<String, Object> additionalProperties) {
        this.categoryId = categoryId;
        this.categoryName = categoryName;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getCategoryId() {
        if (this.categoryId == null) {
            return Optional.empty();
        }
        return this.categoryId;
    }

    @JsonIgnore
    public Optional<String> getCategoryName() {
        if (this.categoryName == null) {
            return Optional.empty();
        }
        return this.categoryName;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="category_id")
    private Optional<String> _getCategoryId() {
        return this.categoryId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="category_name")
    private Optional<String> _getCategoryName() {
        return this.categoryName;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CategoryPathToRootNode && this.equalTo((CategoryPathToRootNode)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CategoryPathToRootNode other) {
        return this.categoryId.equals(other.categoryId) && this.categoryName.equals(other.categoryName);
    }

    public int hashCode() {
        return Objects.hash(this.categoryId, this.categoryName);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> categoryId = Optional.empty();
        private Optional<String> categoryName = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CategoryPathToRootNode other) {
            this.categoryId(other.getCategoryId());
            this.categoryName(other.getCategoryName());
            return this;
        }

        @JsonSetter(value="category_id", nulls=Nulls.SKIP)
        public Builder categoryId(Optional<String> categoryId) {
            this.categoryId = categoryId;
            return this;
        }

        public Builder categoryId(String categoryId) {
            this.categoryId = Optional.ofNullable(categoryId);
            return this;
        }

        public Builder categoryId(Nullable<String> categoryId) {
            this.categoryId = categoryId.isNull() ? null : (categoryId.isEmpty() ? Optional.empty() : Optional.of(categoryId.get()));
            return this;
        }

        @JsonSetter(value="category_name", nulls=Nulls.SKIP)
        public Builder categoryName(Optional<String> categoryName) {
            this.categoryName = categoryName;
            return this;
        }

        public Builder categoryName(String categoryName) {
            this.categoryName = Optional.ofNullable(categoryName);
            return this;
        }

        public Builder categoryName(Nullable<String> categoryName) {
            this.categoryName = categoryName.isNull() ? null : (categoryName.isEmpty() ? Optional.empty() : Optional.of(categoryName.get()));
            return this;
        }

        public CategoryPathToRootNode build() {
            return new CategoryPathToRootNode(this.categoryId, this.categoryName, this.additionalProperties);
        }
    }
}

