/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CatalogObject;
import com.squareup.square.types.SubscriptionPhase;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CatalogSubscriptionPlan {
    private final String name;
    private final Optional<List<SubscriptionPhase>> phases;
    private final Optional<List<CatalogObject>> subscriptionPlanVariations;
    private final Optional<List<String>> eligibleItemIds;
    private final Optional<List<String>> eligibleCategoryIds;
    private final Optional<Boolean> allItems;
    private final Map<String, Object> additionalProperties;

    private CatalogSubscriptionPlan(String name, Optional<List<SubscriptionPhase>> phases, Optional<List<CatalogObject>> subscriptionPlanVariations, Optional<List<String>> eligibleItemIds, Optional<List<String>> eligibleCategoryIds, Optional<Boolean> allItems, Map<String, Object> additionalProperties) {
        this.name = name;
        this.phases = phases;
        this.subscriptionPlanVariations = subscriptionPlanVariations;
        this.eligibleItemIds = eligibleItemIds;
        this.eligibleCategoryIds = eligibleCategoryIds;
        this.allItems = allItems;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonIgnore
    public Optional<List<SubscriptionPhase>> getPhases() {
        if (this.phases == null) {
            return Optional.empty();
        }
        return this.phases;
    }

    @JsonIgnore
    public Optional<List<CatalogObject>> getSubscriptionPlanVariations() {
        if (this.subscriptionPlanVariations == null) {
            return Optional.empty();
        }
        return this.subscriptionPlanVariations;
    }

    @JsonIgnore
    public Optional<List<String>> getEligibleItemIds() {
        if (this.eligibleItemIds == null) {
            return Optional.empty();
        }
        return this.eligibleItemIds;
    }

    @JsonIgnore
    public Optional<List<String>> getEligibleCategoryIds() {
        if (this.eligibleCategoryIds == null) {
            return Optional.empty();
        }
        return this.eligibleCategoryIds;
    }

    @JsonIgnore
    public Optional<Boolean> getAllItems() {
        if (this.allItems == null) {
            return Optional.empty();
        }
        return this.allItems;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="phases")
    private Optional<List<SubscriptionPhase>> _getPhases() {
        return this.phases;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="subscription_plan_variations")
    private Optional<List<CatalogObject>> _getSubscriptionPlanVariations() {
        return this.subscriptionPlanVariations;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="eligible_item_ids")
    private Optional<List<String>> _getEligibleItemIds() {
        return this.eligibleItemIds;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="eligible_category_ids")
    private Optional<List<String>> _getEligibleCategoryIds() {
        return this.eligibleCategoryIds;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="all_items")
    private Optional<Boolean> _getAllItems() {
        return this.allItems;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CatalogSubscriptionPlan && this.equalTo((CatalogSubscriptionPlan)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CatalogSubscriptionPlan other) {
        return this.name.equals(other.name) && this.phases.equals(other.phases) && this.subscriptionPlanVariations.equals(other.subscriptionPlanVariations) && this.eligibleItemIds.equals(other.eligibleItemIds) && this.eligibleCategoryIds.equals(other.eligibleCategoryIds) && this.allItems.equals(other.allItems);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.phases, this.subscriptionPlanVariations, this.eligibleItemIds, this.eligibleCategoryIds, this.allItems);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NameStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements NameStage,
    _FinalStage {
        private String name;
        private Optional<Boolean> allItems = Optional.empty();
        private Optional<List<String>> eligibleCategoryIds = Optional.empty();
        private Optional<List<String>> eligibleItemIds = Optional.empty();
        private Optional<List<CatalogObject>> subscriptionPlanVariations = Optional.empty();
        private Optional<List<SubscriptionPhase>> phases = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CatalogSubscriptionPlan other) {
            this.name(other.getName());
            this.phases(other.getPhases());
            this.subscriptionPlanVariations(other.getSubscriptionPlanVariations());
            this.eligibleItemIds(other.getEligibleItemIds());
            this.eligibleCategoryIds(other.getEligibleCategoryIds());
            this.allItems(other.getAllItems());
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public _FinalStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        public _FinalStage allItems(Nullable<Boolean> allItems) {
            this.allItems = allItems.isNull() ? null : (allItems.isEmpty() ? Optional.empty() : Optional.of(allItems.get()));
            return this;
        }

        @Override
        public _FinalStage allItems(Boolean allItems) {
            this.allItems = Optional.ofNullable(allItems);
            return this;
        }

        @Override
        @JsonSetter(value="all_items", nulls=Nulls.SKIP)
        public _FinalStage allItems(Optional<Boolean> allItems) {
            this.allItems = allItems;
            return this;
        }

        @Override
        public _FinalStage eligibleCategoryIds(Nullable<List<String>> eligibleCategoryIds) {
            this.eligibleCategoryIds = eligibleCategoryIds.isNull() ? null : (eligibleCategoryIds.isEmpty() ? Optional.empty() : Optional.of(eligibleCategoryIds.get()));
            return this;
        }

        @Override
        public _FinalStage eligibleCategoryIds(List<String> eligibleCategoryIds) {
            this.eligibleCategoryIds = Optional.ofNullable(eligibleCategoryIds);
            return this;
        }

        @Override
        @JsonSetter(value="eligible_category_ids", nulls=Nulls.SKIP)
        public _FinalStage eligibleCategoryIds(Optional<List<String>> eligibleCategoryIds) {
            this.eligibleCategoryIds = eligibleCategoryIds;
            return this;
        }

        @Override
        public _FinalStage eligibleItemIds(Nullable<List<String>> eligibleItemIds) {
            this.eligibleItemIds = eligibleItemIds.isNull() ? null : (eligibleItemIds.isEmpty() ? Optional.empty() : Optional.of(eligibleItemIds.get()));
            return this;
        }

        @Override
        public _FinalStage eligibleItemIds(List<String> eligibleItemIds) {
            this.eligibleItemIds = Optional.ofNullable(eligibleItemIds);
            return this;
        }

        @Override
        @JsonSetter(value="eligible_item_ids", nulls=Nulls.SKIP)
        public _FinalStage eligibleItemIds(Optional<List<String>> eligibleItemIds) {
            this.eligibleItemIds = eligibleItemIds;
            return this;
        }

        @Override
        public _FinalStage subscriptionPlanVariations(Nullable<List<CatalogObject>> subscriptionPlanVariations) {
            this.subscriptionPlanVariations = subscriptionPlanVariations.isNull() ? null : (subscriptionPlanVariations.isEmpty() ? Optional.empty() : Optional.of(subscriptionPlanVariations.get()));
            return this;
        }

        @Override
        public _FinalStage subscriptionPlanVariations(List<CatalogObject> subscriptionPlanVariations) {
            this.subscriptionPlanVariations = Optional.ofNullable(subscriptionPlanVariations);
            return this;
        }

        @Override
        @JsonSetter(value="subscription_plan_variations", nulls=Nulls.SKIP)
        public _FinalStage subscriptionPlanVariations(Optional<List<CatalogObject>> subscriptionPlanVariations) {
            this.subscriptionPlanVariations = subscriptionPlanVariations;
            return this;
        }

        @Override
        public _FinalStage phases(Nullable<List<SubscriptionPhase>> phases) {
            this.phases = phases.isNull() ? null : (phases.isEmpty() ? Optional.empty() : Optional.of(phases.get()));
            return this;
        }

        @Override
        public _FinalStage phases(List<SubscriptionPhase> phases) {
            this.phases = Optional.ofNullable(phases);
            return this;
        }

        @Override
        @JsonSetter(value="phases", nulls=Nulls.SKIP)
        public _FinalStage phases(Optional<List<SubscriptionPhase>> phases) {
            this.phases = phases;
            return this;
        }

        @Override
        public CatalogSubscriptionPlan build() {
            return new CatalogSubscriptionPlan(this.name, this.phases, this.subscriptionPlanVariations, this.eligibleItemIds, this.eligibleCategoryIds, this.allItems, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CatalogSubscriptionPlan build();

        public _FinalStage phases(Optional<List<SubscriptionPhase>> var1);

        public _FinalStage phases(List<SubscriptionPhase> var1);

        public _FinalStage phases(Nullable<List<SubscriptionPhase>> var1);

        public _FinalStage subscriptionPlanVariations(Optional<List<CatalogObject>> var1);

        public _FinalStage subscriptionPlanVariations(List<CatalogObject> var1);

        public _FinalStage subscriptionPlanVariations(Nullable<List<CatalogObject>> var1);

        public _FinalStage eligibleItemIds(Optional<List<String>> var1);

        public _FinalStage eligibleItemIds(List<String> var1);

        public _FinalStage eligibleItemIds(Nullable<List<String>> var1);

        public _FinalStage eligibleCategoryIds(Optional<List<String>> var1);

        public _FinalStage eligibleCategoryIds(List<String> var1);

        public _FinalStage eligibleCategoryIds(Nullable<List<String>> var1);

        public _FinalStage allItems(Optional<Boolean> var1);

        public _FinalStage allItems(Boolean var1);

        public _FinalStage allItems(Nullable<Boolean> var1);
    }

    public static interface NameStage {
        public _FinalStage name(@NotNull String var1);

        public Builder from(CatalogSubscriptionPlan var1);
    }
}

