/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CatalogQuickAmount;
import com.squareup.square.types.CatalogQuickAmountsSettingsOption;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CatalogQuickAmountsSettings {
    private final CatalogQuickAmountsSettingsOption option;
    private final Optional<Boolean> eligibleForAutoAmounts;
    private final Optional<List<CatalogQuickAmount>> amounts;
    private final Map<String, Object> additionalProperties;

    private CatalogQuickAmountsSettings(CatalogQuickAmountsSettingsOption option, Optional<Boolean> eligibleForAutoAmounts, Optional<List<CatalogQuickAmount>> amounts, Map<String, Object> additionalProperties) {
        this.option = option;
        this.eligibleForAutoAmounts = eligibleForAutoAmounts;
        this.amounts = amounts;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="option")
    public CatalogQuickAmountsSettingsOption getOption() {
        return this.option;
    }

    @JsonIgnore
    public Optional<Boolean> getEligibleForAutoAmounts() {
        if (this.eligibleForAutoAmounts == null) {
            return Optional.empty();
        }
        return this.eligibleForAutoAmounts;
    }

    @JsonIgnore
    public Optional<List<CatalogQuickAmount>> getAmounts() {
        if (this.amounts == null) {
            return Optional.empty();
        }
        return this.amounts;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="eligible_for_auto_amounts")
    private Optional<Boolean> _getEligibleForAutoAmounts() {
        return this.eligibleForAutoAmounts;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="amounts")
    private Optional<List<CatalogQuickAmount>> _getAmounts() {
        return this.amounts;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CatalogQuickAmountsSettings && this.equalTo((CatalogQuickAmountsSettings)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CatalogQuickAmountsSettings other) {
        return this.option.equals(other.option) && this.eligibleForAutoAmounts.equals(other.eligibleForAutoAmounts) && this.amounts.equals(other.amounts);
    }

    public int hashCode() {
        return Objects.hash(this.option, this.eligibleForAutoAmounts, this.amounts);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static OptionStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements OptionStage,
    _FinalStage {
        private CatalogQuickAmountsSettingsOption option;
        private Optional<List<CatalogQuickAmount>> amounts = Optional.empty();
        private Optional<Boolean> eligibleForAutoAmounts = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CatalogQuickAmountsSettings other) {
            this.option(other.getOption());
            this.eligibleForAutoAmounts(other.getEligibleForAutoAmounts());
            this.amounts(other.getAmounts());
            return this;
        }

        @Override
        @JsonSetter(value="option")
        public _FinalStage option(@NotNull CatalogQuickAmountsSettingsOption option) {
            this.option = Objects.requireNonNull(option, "option must not be null");
            return this;
        }

        @Override
        public _FinalStage amounts(Nullable<List<CatalogQuickAmount>> amounts) {
            this.amounts = amounts.isNull() ? null : (amounts.isEmpty() ? Optional.empty() : Optional.of(amounts.get()));
            return this;
        }

        @Override
        public _FinalStage amounts(List<CatalogQuickAmount> amounts) {
            this.amounts = Optional.ofNullable(amounts);
            return this;
        }

        @Override
        @JsonSetter(value="amounts", nulls=Nulls.SKIP)
        public _FinalStage amounts(Optional<List<CatalogQuickAmount>> amounts) {
            this.amounts = amounts;
            return this;
        }

        @Override
        public _FinalStage eligibleForAutoAmounts(Nullable<Boolean> eligibleForAutoAmounts) {
            this.eligibleForAutoAmounts = eligibleForAutoAmounts.isNull() ? null : (eligibleForAutoAmounts.isEmpty() ? Optional.empty() : Optional.of(eligibleForAutoAmounts.get()));
            return this;
        }

        @Override
        public _FinalStage eligibleForAutoAmounts(Boolean eligibleForAutoAmounts) {
            this.eligibleForAutoAmounts = Optional.ofNullable(eligibleForAutoAmounts);
            return this;
        }

        @Override
        @JsonSetter(value="eligible_for_auto_amounts", nulls=Nulls.SKIP)
        public _FinalStage eligibleForAutoAmounts(Optional<Boolean> eligibleForAutoAmounts) {
            this.eligibleForAutoAmounts = eligibleForAutoAmounts;
            return this;
        }

        @Override
        public CatalogQuickAmountsSettings build() {
            return new CatalogQuickAmountsSettings(this.option, this.eligibleForAutoAmounts, this.amounts, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CatalogQuickAmountsSettings build();

        public _FinalStage eligibleForAutoAmounts(Optional<Boolean> var1);

        public _FinalStage eligibleForAutoAmounts(Boolean var1);

        public _FinalStage eligibleForAutoAmounts(Nullable<Boolean> var1);

        public _FinalStage amounts(Optional<List<CatalogQuickAmount>> var1);

        public _FinalStage amounts(List<CatalogQuickAmount> var1);

        public _FinalStage amounts(Nullable<List<CatalogQuickAmount>> var1);
    }

    public static interface OptionStage {
        public _FinalStage option(@NotNull CatalogQuickAmountsSettingsOption var1);

        public Builder from(CatalogQuickAmountsSettings var1);
    }
}

