/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CatalogQuickAmountType;
import com.squareup.square.types.Money;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CatalogQuickAmount {
    private final CatalogQuickAmountType type;
    private final Money amount;
    private final Optional<Long> score;
    private final Optional<Long> ordinal;
    private final Map<String, Object> additionalProperties;

    private CatalogQuickAmount(CatalogQuickAmountType type, Money amount, Optional<Long> score, Optional<Long> ordinal, Map<String, Object> additionalProperties) {
        this.type = type;
        this.amount = amount;
        this.score = score;
        this.ordinal = ordinal;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public CatalogQuickAmountType getType() {
        return this.type;
    }

    @JsonProperty(value="amount")
    public Money getAmount() {
        return this.amount;
    }

    @JsonIgnore
    public Optional<Long> getScore() {
        if (this.score == null) {
            return Optional.empty();
        }
        return this.score;
    }

    @JsonIgnore
    public Optional<Long> getOrdinal() {
        if (this.ordinal == null) {
            return Optional.empty();
        }
        return this.ordinal;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="score")
    private Optional<Long> _getScore() {
        return this.score;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="ordinal")
    private Optional<Long> _getOrdinal() {
        return this.ordinal;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CatalogQuickAmount && this.equalTo((CatalogQuickAmount)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CatalogQuickAmount other) {
        return this.type.equals(other.type) && this.amount.equals(other.amount) && this.score.equals(other.score) && this.ordinal.equals(other.ordinal);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.amount, this.score, this.ordinal);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TypeStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TypeStage,
    AmountStage,
    _FinalStage {
        private CatalogQuickAmountType type;
        private Money amount;
        private Optional<Long> ordinal = Optional.empty();
        private Optional<Long> score = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CatalogQuickAmount other) {
            this.type(other.getType());
            this.amount(other.getAmount());
            this.score(other.getScore());
            this.ordinal(other.getOrdinal());
            return this;
        }

        @Override
        @JsonSetter(value="type")
        public AmountStage type(@NotNull CatalogQuickAmountType type) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="amount")
        public _FinalStage amount(@NotNull Money amount) {
            this.amount = Objects.requireNonNull(amount, "amount must not be null");
            return this;
        }

        @Override
        public _FinalStage ordinal(Nullable<Long> ordinal) {
            this.ordinal = ordinal.isNull() ? null : (ordinal.isEmpty() ? Optional.empty() : Optional.of(ordinal.get()));
            return this;
        }

        @Override
        public _FinalStage ordinal(Long ordinal) {
            this.ordinal = Optional.ofNullable(ordinal);
            return this;
        }

        @Override
        @JsonSetter(value="ordinal", nulls=Nulls.SKIP)
        public _FinalStage ordinal(Optional<Long> ordinal) {
            this.ordinal = ordinal;
            return this;
        }

        @Override
        public _FinalStage score(Nullable<Long> score) {
            this.score = score.isNull() ? null : (score.isEmpty() ? Optional.empty() : Optional.of(score.get()));
            return this;
        }

        @Override
        public _FinalStage score(Long score) {
            this.score = Optional.ofNullable(score);
            return this;
        }

        @Override
        @JsonSetter(value="score", nulls=Nulls.SKIP)
        public _FinalStage score(Optional<Long> score) {
            this.score = score;
            return this;
        }

        @Override
        public CatalogQuickAmount build() {
            return new CatalogQuickAmount(this.type, this.amount, this.score, this.ordinal, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CatalogQuickAmount build();

        public _FinalStage score(Optional<Long> var1);

        public _FinalStage score(Long var1);

        public _FinalStage score(Nullable<Long> var1);

        public _FinalStage ordinal(Optional<Long> var1);

        public _FinalStage ordinal(Long var1);

        public _FinalStage ordinal(Nullable<Long> var1);
    }

    public static interface AmountStage {
        public _FinalStage amount(@NotNull Money var1);
    }

    public static interface TypeStage {
        public AmountStage type(@NotNull CatalogQuickAmountType var1);

        public Builder from(CatalogQuickAmount var1);
    }
}

