/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.SortOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CatalogQuerySortedAttribute {
    private final String attributeName;
    private final Optional<String> initialAttributeValue;
    private final Optional<SortOrder> sortOrder;
    private final Map<String, Object> additionalProperties;

    private CatalogQuerySortedAttribute(String attributeName, Optional<String> initialAttributeValue, Optional<SortOrder> sortOrder, Map<String, Object> additionalProperties) {
        this.attributeName = attributeName;
        this.initialAttributeValue = initialAttributeValue;
        this.sortOrder = sortOrder;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="attribute_name")
    public String getAttributeName() {
        return this.attributeName;
    }

    @JsonIgnore
    public Optional<String> getInitialAttributeValue() {
        if (this.initialAttributeValue == null) {
            return Optional.empty();
        }
        return this.initialAttributeValue;
    }

    @JsonProperty(value="sort_order")
    public Optional<SortOrder> getSortOrder() {
        return this.sortOrder;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="initial_attribute_value")
    private Optional<String> _getInitialAttributeValue() {
        return this.initialAttributeValue;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CatalogQuerySortedAttribute && this.equalTo((CatalogQuerySortedAttribute)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CatalogQuerySortedAttribute other) {
        return this.attributeName.equals(other.attributeName) && this.initialAttributeValue.equals(other.initialAttributeValue) && this.sortOrder.equals(other.sortOrder);
    }

    public int hashCode() {
        return Objects.hash(this.attributeName, this.initialAttributeValue, this.sortOrder);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static AttributeNameStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements AttributeNameStage,
    _FinalStage {
        private String attributeName;
        private Optional<SortOrder> sortOrder = Optional.empty();
        private Optional<String> initialAttributeValue = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CatalogQuerySortedAttribute other) {
            this.attributeName(other.getAttributeName());
            this.initialAttributeValue(other.getInitialAttributeValue());
            this.sortOrder(other.getSortOrder());
            return this;
        }

        @Override
        @JsonSetter(value="attribute_name")
        public _FinalStage attributeName(@NotNull String attributeName) {
            this.attributeName = Objects.requireNonNull(attributeName, "attributeName must not be null");
            return this;
        }

        @Override
        public _FinalStage sortOrder(SortOrder sortOrder) {
            this.sortOrder = Optional.ofNullable(sortOrder);
            return this;
        }

        @Override
        @JsonSetter(value="sort_order", nulls=Nulls.SKIP)
        public _FinalStage sortOrder(Optional<SortOrder> sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public _FinalStage initialAttributeValue(Nullable<String> initialAttributeValue) {
            this.initialAttributeValue = initialAttributeValue.isNull() ? null : (initialAttributeValue.isEmpty() ? Optional.empty() : Optional.of(initialAttributeValue.get()));
            return this;
        }

        @Override
        public _FinalStage initialAttributeValue(String initialAttributeValue) {
            this.initialAttributeValue = Optional.ofNullable(initialAttributeValue);
            return this;
        }

        @Override
        @JsonSetter(value="initial_attribute_value", nulls=Nulls.SKIP)
        public _FinalStage initialAttributeValue(Optional<String> initialAttributeValue) {
            this.initialAttributeValue = initialAttributeValue;
            return this;
        }

        @Override
        public CatalogQuerySortedAttribute build() {
            return new CatalogQuerySortedAttribute(this.attributeName, this.initialAttributeValue, this.sortOrder, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CatalogQuerySortedAttribute build();

        public _FinalStage initialAttributeValue(Optional<String> var1);

        public _FinalStage initialAttributeValue(String var1);

        public _FinalStage initialAttributeValue(Nullable<String> var1);

        public _FinalStage sortOrder(Optional<SortOrder> var1);

        public _FinalStage sortOrder(SortOrder var1);
    }

    public static interface AttributeNameStage {
        public _FinalStage attributeName(@NotNull String var1);

        public Builder from(CatalogQuerySortedAttribute var1);
    }
}

