/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CatalogQueryPrefix {
    private final String attributeName;
    private final String attributePrefix;
    private final Map<String, Object> additionalProperties;

    private CatalogQueryPrefix(String attributeName, String attributePrefix, Map<String, Object> additionalProperties) {
        this.attributeName = attributeName;
        this.attributePrefix = attributePrefix;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="attribute_name")
    public String getAttributeName() {
        return this.attributeName;
    }

    @JsonProperty(value="attribute_prefix")
    public String getAttributePrefix() {
        return this.attributePrefix;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CatalogQueryPrefix && this.equalTo((CatalogQueryPrefix)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CatalogQueryPrefix other) {
        return this.attributeName.equals(other.attributeName) && this.attributePrefix.equals(other.attributePrefix);
    }

    public int hashCode() {
        return Objects.hash(this.attributeName, this.attributePrefix);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static AttributeNameStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements AttributeNameStage,
    AttributePrefixStage,
    _FinalStage {
        private String attributeName;
        private String attributePrefix;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CatalogQueryPrefix other) {
            this.attributeName(other.getAttributeName());
            this.attributePrefix(other.getAttributePrefix());
            return this;
        }

        @Override
        @JsonSetter(value="attribute_name")
        public AttributePrefixStage attributeName(@NotNull String attributeName) {
            this.attributeName = Objects.requireNonNull(attributeName, "attributeName must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="attribute_prefix")
        public _FinalStage attributePrefix(@NotNull String attributePrefix) {
            this.attributePrefix = Objects.requireNonNull(attributePrefix, "attributePrefix must not be null");
            return this;
        }

        @Override
        public CatalogQueryPrefix build() {
            return new CatalogQueryPrefix(this.attributeName, this.attributePrefix, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CatalogQueryPrefix build();
    }

    public static interface AttributePrefixStage {
        public _FinalStage attributePrefix(@NotNull String var1);
    }

    public static interface AttributeNameStage {
        public AttributePrefixStage attributeName(@NotNull String var1);

        public Builder from(CatalogQueryPrefix var1);
    }
}

