/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CatalogQueryExact;
import com.squareup.square.types.CatalogQueryItemVariationsForItemOptionValues;
import com.squareup.square.types.CatalogQueryItemsForItemOptions;
import com.squareup.square.types.CatalogQueryItemsForModifierList;
import com.squareup.square.types.CatalogQueryItemsForTax;
import com.squareup.square.types.CatalogQueryPrefix;
import com.squareup.square.types.CatalogQueryRange;
import com.squareup.square.types.CatalogQuerySet;
import com.squareup.square.types.CatalogQuerySortedAttribute;
import com.squareup.square.types.CatalogQueryText;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CatalogQuery {
    private final Optional<CatalogQuerySortedAttribute> sortedAttributeQuery;
    private final Optional<CatalogQueryExact> exactQuery;
    private final Optional<CatalogQuerySet> setQuery;
    private final Optional<CatalogQueryPrefix> prefixQuery;
    private final Optional<CatalogQueryRange> rangeQuery;
    private final Optional<CatalogQueryText> textQuery;
    private final Optional<CatalogQueryItemsForTax> itemsForTaxQuery;
    private final Optional<CatalogQueryItemsForModifierList> itemsForModifierListQuery;
    private final Optional<CatalogQueryItemsForItemOptions> itemsForItemOptionsQuery;
    private final Optional<CatalogQueryItemVariationsForItemOptionValues> itemVariationsForItemOptionValuesQuery;
    private final Map<String, Object> additionalProperties;

    private CatalogQuery(Optional<CatalogQuerySortedAttribute> sortedAttributeQuery, Optional<CatalogQueryExact> exactQuery, Optional<CatalogQuerySet> setQuery, Optional<CatalogQueryPrefix> prefixQuery, Optional<CatalogQueryRange> rangeQuery, Optional<CatalogQueryText> textQuery, Optional<CatalogQueryItemsForTax> itemsForTaxQuery, Optional<CatalogQueryItemsForModifierList> itemsForModifierListQuery, Optional<CatalogQueryItemsForItemOptions> itemsForItemOptionsQuery, Optional<CatalogQueryItemVariationsForItemOptionValues> itemVariationsForItemOptionValuesQuery, Map<String, Object> additionalProperties) {
        this.sortedAttributeQuery = sortedAttributeQuery;
        this.exactQuery = exactQuery;
        this.setQuery = setQuery;
        this.prefixQuery = prefixQuery;
        this.rangeQuery = rangeQuery;
        this.textQuery = textQuery;
        this.itemsForTaxQuery = itemsForTaxQuery;
        this.itemsForModifierListQuery = itemsForModifierListQuery;
        this.itemsForItemOptionsQuery = itemsForItemOptionsQuery;
        this.itemVariationsForItemOptionValuesQuery = itemVariationsForItemOptionValuesQuery;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="sorted_attribute_query")
    public Optional<CatalogQuerySortedAttribute> getSortedAttributeQuery() {
        return this.sortedAttributeQuery;
    }

    @JsonProperty(value="exact_query")
    public Optional<CatalogQueryExact> getExactQuery() {
        return this.exactQuery;
    }

    @JsonProperty(value="set_query")
    public Optional<CatalogQuerySet> getSetQuery() {
        return this.setQuery;
    }

    @JsonProperty(value="prefix_query")
    public Optional<CatalogQueryPrefix> getPrefixQuery() {
        return this.prefixQuery;
    }

    @JsonProperty(value="range_query")
    public Optional<CatalogQueryRange> getRangeQuery() {
        return this.rangeQuery;
    }

    @JsonProperty(value="text_query")
    public Optional<CatalogQueryText> getTextQuery() {
        return this.textQuery;
    }

    @JsonProperty(value="items_for_tax_query")
    public Optional<CatalogQueryItemsForTax> getItemsForTaxQuery() {
        return this.itemsForTaxQuery;
    }

    @JsonProperty(value="items_for_modifier_list_query")
    public Optional<CatalogQueryItemsForModifierList> getItemsForModifierListQuery() {
        return this.itemsForModifierListQuery;
    }

    @JsonProperty(value="items_for_item_options_query")
    public Optional<CatalogQueryItemsForItemOptions> getItemsForItemOptionsQuery() {
        return this.itemsForItemOptionsQuery;
    }

    @JsonProperty(value="item_variations_for_item_option_values_query")
    public Optional<CatalogQueryItemVariationsForItemOptionValues> getItemVariationsForItemOptionValuesQuery() {
        return this.itemVariationsForItemOptionValuesQuery;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CatalogQuery && this.equalTo((CatalogQuery)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CatalogQuery other) {
        return this.sortedAttributeQuery.equals(other.sortedAttributeQuery) && this.exactQuery.equals(other.exactQuery) && this.setQuery.equals(other.setQuery) && this.prefixQuery.equals(other.prefixQuery) && this.rangeQuery.equals(other.rangeQuery) && this.textQuery.equals(other.textQuery) && this.itemsForTaxQuery.equals(other.itemsForTaxQuery) && this.itemsForModifierListQuery.equals(other.itemsForModifierListQuery) && this.itemsForItemOptionsQuery.equals(other.itemsForItemOptionsQuery) && this.itemVariationsForItemOptionValuesQuery.equals(other.itemVariationsForItemOptionValuesQuery);
    }

    public int hashCode() {
        return Objects.hash(this.sortedAttributeQuery, this.exactQuery, this.setQuery, this.prefixQuery, this.rangeQuery, this.textQuery, this.itemsForTaxQuery, this.itemsForModifierListQuery, this.itemsForItemOptionsQuery, this.itemVariationsForItemOptionValuesQuery);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<CatalogQuerySortedAttribute> sortedAttributeQuery = Optional.empty();
        private Optional<CatalogQueryExact> exactQuery = Optional.empty();
        private Optional<CatalogQuerySet> setQuery = Optional.empty();
        private Optional<CatalogQueryPrefix> prefixQuery = Optional.empty();
        private Optional<CatalogQueryRange> rangeQuery = Optional.empty();
        private Optional<CatalogQueryText> textQuery = Optional.empty();
        private Optional<CatalogQueryItemsForTax> itemsForTaxQuery = Optional.empty();
        private Optional<CatalogQueryItemsForModifierList> itemsForModifierListQuery = Optional.empty();
        private Optional<CatalogQueryItemsForItemOptions> itemsForItemOptionsQuery = Optional.empty();
        private Optional<CatalogQueryItemVariationsForItemOptionValues> itemVariationsForItemOptionValuesQuery = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CatalogQuery other) {
            this.sortedAttributeQuery(other.getSortedAttributeQuery());
            this.exactQuery(other.getExactQuery());
            this.setQuery(other.getSetQuery());
            this.prefixQuery(other.getPrefixQuery());
            this.rangeQuery(other.getRangeQuery());
            this.textQuery(other.getTextQuery());
            this.itemsForTaxQuery(other.getItemsForTaxQuery());
            this.itemsForModifierListQuery(other.getItemsForModifierListQuery());
            this.itemsForItemOptionsQuery(other.getItemsForItemOptionsQuery());
            this.itemVariationsForItemOptionValuesQuery(other.getItemVariationsForItemOptionValuesQuery());
            return this;
        }

        @JsonSetter(value="sorted_attribute_query", nulls=Nulls.SKIP)
        public Builder sortedAttributeQuery(Optional<CatalogQuerySortedAttribute> sortedAttributeQuery) {
            this.sortedAttributeQuery = sortedAttributeQuery;
            return this;
        }

        public Builder sortedAttributeQuery(CatalogQuerySortedAttribute sortedAttributeQuery) {
            this.sortedAttributeQuery = Optional.ofNullable(sortedAttributeQuery);
            return this;
        }

        @JsonSetter(value="exact_query", nulls=Nulls.SKIP)
        public Builder exactQuery(Optional<CatalogQueryExact> exactQuery) {
            this.exactQuery = exactQuery;
            return this;
        }

        public Builder exactQuery(CatalogQueryExact exactQuery) {
            this.exactQuery = Optional.ofNullable(exactQuery);
            return this;
        }

        @JsonSetter(value="set_query", nulls=Nulls.SKIP)
        public Builder setQuery(Optional<CatalogQuerySet> setQuery) {
            this.setQuery = setQuery;
            return this;
        }

        public Builder setQuery(CatalogQuerySet setQuery) {
            this.setQuery = Optional.ofNullable(setQuery);
            return this;
        }

        @JsonSetter(value="prefix_query", nulls=Nulls.SKIP)
        public Builder prefixQuery(Optional<CatalogQueryPrefix> prefixQuery) {
            this.prefixQuery = prefixQuery;
            return this;
        }

        public Builder prefixQuery(CatalogQueryPrefix prefixQuery) {
            this.prefixQuery = Optional.ofNullable(prefixQuery);
            return this;
        }

        @JsonSetter(value="range_query", nulls=Nulls.SKIP)
        public Builder rangeQuery(Optional<CatalogQueryRange> rangeQuery) {
            this.rangeQuery = rangeQuery;
            return this;
        }

        public Builder rangeQuery(CatalogQueryRange rangeQuery) {
            this.rangeQuery = Optional.ofNullable(rangeQuery);
            return this;
        }

        @JsonSetter(value="text_query", nulls=Nulls.SKIP)
        public Builder textQuery(Optional<CatalogQueryText> textQuery) {
            this.textQuery = textQuery;
            return this;
        }

        public Builder textQuery(CatalogQueryText textQuery) {
            this.textQuery = Optional.ofNullable(textQuery);
            return this;
        }

        @JsonSetter(value="items_for_tax_query", nulls=Nulls.SKIP)
        public Builder itemsForTaxQuery(Optional<CatalogQueryItemsForTax> itemsForTaxQuery) {
            this.itemsForTaxQuery = itemsForTaxQuery;
            return this;
        }

        public Builder itemsForTaxQuery(CatalogQueryItemsForTax itemsForTaxQuery) {
            this.itemsForTaxQuery = Optional.ofNullable(itemsForTaxQuery);
            return this;
        }

        @JsonSetter(value="items_for_modifier_list_query", nulls=Nulls.SKIP)
        public Builder itemsForModifierListQuery(Optional<CatalogQueryItemsForModifierList> itemsForModifierListQuery) {
            this.itemsForModifierListQuery = itemsForModifierListQuery;
            return this;
        }

        public Builder itemsForModifierListQuery(CatalogQueryItemsForModifierList itemsForModifierListQuery) {
            this.itemsForModifierListQuery = Optional.ofNullable(itemsForModifierListQuery);
            return this;
        }

        @JsonSetter(value="items_for_item_options_query", nulls=Nulls.SKIP)
        public Builder itemsForItemOptionsQuery(Optional<CatalogQueryItemsForItemOptions> itemsForItemOptionsQuery) {
            this.itemsForItemOptionsQuery = itemsForItemOptionsQuery;
            return this;
        }

        public Builder itemsForItemOptionsQuery(CatalogQueryItemsForItemOptions itemsForItemOptionsQuery) {
            this.itemsForItemOptionsQuery = Optional.ofNullable(itemsForItemOptionsQuery);
            return this;
        }

        @JsonSetter(value="item_variations_for_item_option_values_query", nulls=Nulls.SKIP)
        public Builder itemVariationsForItemOptionValuesQuery(Optional<CatalogQueryItemVariationsForItemOptionValues> itemVariationsForItemOptionValuesQuery) {
            this.itemVariationsForItemOptionValuesQuery = itemVariationsForItemOptionValuesQuery;
            return this;
        }

        public Builder itemVariationsForItemOptionValuesQuery(CatalogQueryItemVariationsForItemOptionValues itemVariationsForItemOptionValuesQuery) {
            this.itemVariationsForItemOptionValuesQuery = Optional.ofNullable(itemVariationsForItemOptionValuesQuery);
            return this;
        }

        public CatalogQuery build() {
            return new CatalogQuery(this.sortedAttributeQuery, this.exactQuery, this.setQuery, this.prefixQuery, this.rangeQuery, this.textQuery, this.itemsForTaxQuery, this.itemsForModifierListQuery, this.itemsForItemOptionsQuery, this.itemVariationsForItemOptionValuesQuery, this.additionalProperties);
        }
    }
}

