/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CatalogCategory;
import com.squareup.square.types.CatalogCustomAttributeValue;
import com.squareup.square.types.CatalogV1Id;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CatalogObjectCategory {
    private final Optional<String> id;
    private final Optional<Long> ordinal;
    private final Optional<CatalogCategory> categoryData;
    private final Optional<String> updatedAt;
    private final Optional<Long> version;
    private final Optional<Boolean> isDeleted;
    private final Optional<Map<String, CatalogCustomAttributeValue>> customAttributeValues;
    private final Optional<List<CatalogV1Id>> catalogV1Ids;
    private final Optional<Boolean> presentAtAllLocations;
    private final Optional<List<String>> presentAtLocationIds;
    private final Optional<List<String>> absentAtLocationIds;
    private final Optional<String> imageId;
    private final Map<String, Object> additionalProperties;

    private CatalogObjectCategory(Optional<String> id, Optional<Long> ordinal, Optional<CatalogCategory> categoryData, Optional<String> updatedAt, Optional<Long> version, Optional<Boolean> isDeleted, Optional<Map<String, CatalogCustomAttributeValue>> customAttributeValues, Optional<List<CatalogV1Id>> catalogV1Ids, Optional<Boolean> presentAtAllLocations, Optional<List<String>> presentAtLocationIds, Optional<List<String>> absentAtLocationIds, Optional<String> imageId, Map<String, Object> additionalProperties) {
        this.id = id;
        this.ordinal = ordinal;
        this.categoryData = categoryData;
        this.updatedAt = updatedAt;
        this.version = version;
        this.isDeleted = isDeleted;
        this.customAttributeValues = customAttributeValues;
        this.catalogV1Ids = catalogV1Ids;
        this.presentAtAllLocations = presentAtAllLocations;
        this.presentAtLocationIds = presentAtLocationIds;
        this.absentAtLocationIds = absentAtLocationIds;
        this.imageId = imageId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonIgnore
    public Optional<Long> getOrdinal() {
        if (this.ordinal == null) {
            return Optional.empty();
        }
        return this.ordinal;
    }

    @JsonProperty(value="category_data")
    public Optional<CatalogCategory> getCategoryData() {
        return this.categoryData;
    }

    @JsonProperty(value="updated_at")
    public Optional<String> getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="version")
    public Optional<Long> getVersion() {
        return this.version;
    }

    @JsonProperty(value="is_deleted")
    public Optional<Boolean> getIsDeleted() {
        return this.isDeleted;
    }

    @JsonProperty(value="custom_attribute_values")
    public Optional<Map<String, CatalogCustomAttributeValue>> getCustomAttributeValues() {
        return this.customAttributeValues;
    }

    @JsonProperty(value="catalog_v1_ids")
    public Optional<List<CatalogV1Id>> getCatalogV1Ids() {
        return this.catalogV1Ids;
    }

    @JsonProperty(value="present_at_all_locations")
    public Optional<Boolean> getPresentAtAllLocations() {
        return this.presentAtAllLocations;
    }

    @JsonProperty(value="present_at_location_ids")
    public Optional<List<String>> getPresentAtLocationIds() {
        return this.presentAtLocationIds;
    }

    @JsonProperty(value="absent_at_location_ids")
    public Optional<List<String>> getAbsentAtLocationIds() {
        return this.absentAtLocationIds;
    }

    @JsonProperty(value="image_id")
    public Optional<String> getImageId() {
        return this.imageId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="ordinal")
    private Optional<Long> _getOrdinal() {
        return this.ordinal;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CatalogObjectCategory && this.equalTo((CatalogObjectCategory)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CatalogObjectCategory other) {
        return this.id.equals(other.id) && this.ordinal.equals(other.ordinal) && this.categoryData.equals(other.categoryData) && this.updatedAt.equals(other.updatedAt) && this.version.equals(other.version) && this.isDeleted.equals(other.isDeleted) && this.customAttributeValues.equals(other.customAttributeValues) && this.catalogV1Ids.equals(other.catalogV1Ids) && this.presentAtAllLocations.equals(other.presentAtAllLocations) && this.presentAtLocationIds.equals(other.presentAtLocationIds) && this.absentAtLocationIds.equals(other.absentAtLocationIds) && this.imageId.equals(other.imageId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.ordinal, this.categoryData, this.updatedAt, this.version, this.isDeleted, this.customAttributeValues, this.catalogV1Ids, this.presentAtAllLocations, this.presentAtLocationIds, this.absentAtLocationIds, this.imageId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<Long> ordinal = Optional.empty();
        private Optional<CatalogCategory> categoryData = Optional.empty();
        private Optional<String> updatedAt = Optional.empty();
        private Optional<Long> version = Optional.empty();
        private Optional<Boolean> isDeleted = Optional.empty();
        private Optional<Map<String, CatalogCustomAttributeValue>> customAttributeValues = Optional.empty();
        private Optional<List<CatalogV1Id>> catalogV1Ids = Optional.empty();
        private Optional<Boolean> presentAtAllLocations = Optional.empty();
        private Optional<List<String>> presentAtLocationIds = Optional.empty();
        private Optional<List<String>> absentAtLocationIds = Optional.empty();
        private Optional<String> imageId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CatalogObjectCategory other) {
            this.id(other.getId());
            this.ordinal(other.getOrdinal());
            this.categoryData(other.getCategoryData());
            this.updatedAt(other.getUpdatedAt());
            this.version(other.getVersion());
            this.isDeleted(other.getIsDeleted());
            this.customAttributeValues(other.getCustomAttributeValues());
            this.catalogV1Ids(other.getCatalogV1Ids());
            this.presentAtAllLocations(other.getPresentAtAllLocations());
            this.presentAtLocationIds(other.getPresentAtLocationIds());
            this.absentAtLocationIds(other.getAbsentAtLocationIds());
            this.imageId(other.getImageId());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="ordinal", nulls=Nulls.SKIP)
        public Builder ordinal(Optional<Long> ordinal) {
            this.ordinal = ordinal;
            return this;
        }

        public Builder ordinal(Long ordinal) {
            this.ordinal = Optional.ofNullable(ordinal);
            return this;
        }

        public Builder ordinal(Nullable<Long> ordinal) {
            this.ordinal = ordinal.isNull() ? null : (ordinal.isEmpty() ? Optional.empty() : Optional.of(ordinal.get()));
            return this;
        }

        @JsonSetter(value="category_data", nulls=Nulls.SKIP)
        public Builder categoryData(Optional<CatalogCategory> categoryData) {
            this.categoryData = categoryData;
            return this;
        }

        public Builder categoryData(CatalogCategory categoryData) {
            this.categoryData = Optional.ofNullable(categoryData);
            return this;
        }

        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public Builder updatedAt(Optional<String> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @JsonSetter(value="version", nulls=Nulls.SKIP)
        public Builder version(Optional<Long> version) {
            this.version = version;
            return this;
        }

        public Builder version(Long version) {
            this.version = Optional.ofNullable(version);
            return this;
        }

        @JsonSetter(value="is_deleted", nulls=Nulls.SKIP)
        public Builder isDeleted(Optional<Boolean> isDeleted) {
            this.isDeleted = isDeleted;
            return this;
        }

        public Builder isDeleted(Boolean isDeleted) {
            this.isDeleted = Optional.ofNullable(isDeleted);
            return this;
        }

        @JsonSetter(value="custom_attribute_values", nulls=Nulls.SKIP)
        public Builder customAttributeValues(Optional<Map<String, CatalogCustomAttributeValue>> customAttributeValues) {
            this.customAttributeValues = customAttributeValues;
            return this;
        }

        public Builder customAttributeValues(Map<String, CatalogCustomAttributeValue> customAttributeValues) {
            this.customAttributeValues = Optional.ofNullable(customAttributeValues);
            return this;
        }

        @JsonSetter(value="catalog_v1_ids", nulls=Nulls.SKIP)
        public Builder catalogV1Ids(Optional<List<CatalogV1Id>> catalogV1Ids) {
            this.catalogV1Ids = catalogV1Ids;
            return this;
        }

        public Builder catalogV1Ids(List<CatalogV1Id> catalogV1Ids) {
            this.catalogV1Ids = Optional.ofNullable(catalogV1Ids);
            return this;
        }

        @JsonSetter(value="present_at_all_locations", nulls=Nulls.SKIP)
        public Builder presentAtAllLocations(Optional<Boolean> presentAtAllLocations) {
            this.presentAtAllLocations = presentAtAllLocations;
            return this;
        }

        public Builder presentAtAllLocations(Boolean presentAtAllLocations) {
            this.presentAtAllLocations = Optional.ofNullable(presentAtAllLocations);
            return this;
        }

        @JsonSetter(value="present_at_location_ids", nulls=Nulls.SKIP)
        public Builder presentAtLocationIds(Optional<List<String>> presentAtLocationIds) {
            this.presentAtLocationIds = presentAtLocationIds;
            return this;
        }

        public Builder presentAtLocationIds(List<String> presentAtLocationIds) {
            this.presentAtLocationIds = Optional.ofNullable(presentAtLocationIds);
            return this;
        }

        @JsonSetter(value="absent_at_location_ids", nulls=Nulls.SKIP)
        public Builder absentAtLocationIds(Optional<List<String>> absentAtLocationIds) {
            this.absentAtLocationIds = absentAtLocationIds;
            return this;
        }

        public Builder absentAtLocationIds(List<String> absentAtLocationIds) {
            this.absentAtLocationIds = Optional.ofNullable(absentAtLocationIds);
            return this;
        }

        @JsonSetter(value="image_id", nulls=Nulls.SKIP)
        public Builder imageId(Optional<String> imageId) {
            this.imageId = imageId;
            return this;
        }

        public Builder imageId(String imageId) {
            this.imageId = Optional.ofNullable(imageId);
            return this;
        }

        public CatalogObjectCategory build() {
            return new CatalogObjectCategory(this.id, this.ordinal, this.categoryData, this.updatedAt, this.version, this.isDeleted, this.customAttributeValues, this.catalogV1Ids, this.presentAtAllLocations, this.presentAtLocationIds, this.absentAtLocationIds, this.imageId, this.additionalProperties);
        }
    }
}

