/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CatalogObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CatalogObjectBatch {
    private final List<CatalogObject> objects;
    private final Map<String, Object> additionalProperties;

    private CatalogObjectBatch(List<CatalogObject> objects, Map<String, Object> additionalProperties) {
        this.objects = objects;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="objects")
    public List<CatalogObject> getObjects() {
        return this.objects;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CatalogObjectBatch && this.equalTo((CatalogObjectBatch)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CatalogObjectBatch other) {
        return this.objects.equals(other.objects);
    }

    public int hashCode() {
        return Objects.hash(this.objects);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private List<CatalogObject> objects = new ArrayList<CatalogObject>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CatalogObjectBatch other) {
            this.objects(other.getObjects());
            return this;
        }

        @JsonSetter(value="objects", nulls=Nulls.SKIP)
        public Builder objects(List<CatalogObject> objects) {
            this.objects.clear();
            this.objects.addAll(objects);
            return this;
        }

        public Builder addObjects(CatalogObject objects) {
            this.objects.add(objects);
            return this;
        }

        public Builder addAllObjects(List<CatalogObject> objects) {
            this.objects.addAll(objects);
            return this;
        }

        public CatalogObjectBatch build() {
            return new CatalogObjectBatch(this.objects, this.additionalProperties);
        }
    }
}

