/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.MeasurementUnit;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CatalogMeasurementUnit {
    private final Optional<MeasurementUnit> measurementUnit;
    private final Optional<Integer> precision;
    private final Map<String, Object> additionalProperties;

    private CatalogMeasurementUnit(Optional<MeasurementUnit> measurementUnit, Optional<Integer> precision, Map<String, Object> additionalProperties) {
        this.measurementUnit = measurementUnit;
        this.precision = precision;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="measurement_unit")
    public Optional<MeasurementUnit> getMeasurementUnit() {
        return this.measurementUnit;
    }

    @JsonIgnore
    public Optional<Integer> getPrecision() {
        if (this.precision == null) {
            return Optional.empty();
        }
        return this.precision;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="precision")
    private Optional<Integer> _getPrecision() {
        return this.precision;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CatalogMeasurementUnit && this.equalTo((CatalogMeasurementUnit)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CatalogMeasurementUnit other) {
        return this.measurementUnit.equals(other.measurementUnit) && this.precision.equals(other.precision);
    }

    public int hashCode() {
        return Objects.hash(this.measurementUnit, this.precision);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<MeasurementUnit> measurementUnit = Optional.empty();
        private Optional<Integer> precision = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CatalogMeasurementUnit other) {
            this.measurementUnit(other.getMeasurementUnit());
            this.precision(other.getPrecision());
            return this;
        }

        @JsonSetter(value="measurement_unit", nulls=Nulls.SKIP)
        public Builder measurementUnit(Optional<MeasurementUnit> measurementUnit) {
            this.measurementUnit = measurementUnit;
            return this;
        }

        public Builder measurementUnit(MeasurementUnit measurementUnit) {
            this.measurementUnit = Optional.ofNullable(measurementUnit);
            return this;
        }

        @JsonSetter(value="precision", nulls=Nulls.SKIP)
        public Builder precision(Optional<Integer> precision) {
            this.precision = precision;
            return this;
        }

        public Builder precision(Integer precision) {
            this.precision = Optional.ofNullable(precision);
            return this;
        }

        public Builder precision(Nullable<Integer> precision) {
            this.precision = precision.isNull() ? null : (precision.isEmpty() ? Optional.empty() : Optional.of(precision.get()));
            return this;
        }

        public CatalogMeasurementUnit build() {
            return new CatalogMeasurementUnit(this.measurementUnit, this.precision, this.additionalProperties);
        }
    }
}

