/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CatalogModifierOverride;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CatalogItemModifierListInfo {
    private final String modifierListId;
    private final Optional<List<CatalogModifierOverride>> modifierOverrides;
    private final Optional<Integer> minSelectedModifiers;
    private final Optional<Integer> maxSelectedModifiers;
    private final Optional<Boolean> enabled;
    private final Optional<Integer> ordinal;
    private final Optional<Object> allowQuantities;
    private final Optional<Object> isConversational;
    private final Optional<Object> hiddenFromCustomerOverride;
    private final Map<String, Object> additionalProperties;

    private CatalogItemModifierListInfo(String modifierListId, Optional<List<CatalogModifierOverride>> modifierOverrides, Optional<Integer> minSelectedModifiers, Optional<Integer> maxSelectedModifiers, Optional<Boolean> enabled, Optional<Integer> ordinal, Optional<Object> allowQuantities, Optional<Object> isConversational, Optional<Object> hiddenFromCustomerOverride, Map<String, Object> additionalProperties) {
        this.modifierListId = modifierListId;
        this.modifierOverrides = modifierOverrides;
        this.minSelectedModifiers = minSelectedModifiers;
        this.maxSelectedModifiers = maxSelectedModifiers;
        this.enabled = enabled;
        this.ordinal = ordinal;
        this.allowQuantities = allowQuantities;
        this.isConversational = isConversational;
        this.hiddenFromCustomerOverride = hiddenFromCustomerOverride;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="modifier_list_id")
    public String getModifierListId() {
        return this.modifierListId;
    }

    @JsonIgnore
    public Optional<List<CatalogModifierOverride>> getModifierOverrides() {
        if (this.modifierOverrides == null) {
            return Optional.empty();
        }
        return this.modifierOverrides;
    }

    @JsonIgnore
    public Optional<Integer> getMinSelectedModifiers() {
        if (this.minSelectedModifiers == null) {
            return Optional.empty();
        }
        return this.minSelectedModifiers;
    }

    @JsonIgnore
    public Optional<Integer> getMaxSelectedModifiers() {
        if (this.maxSelectedModifiers == null) {
            return Optional.empty();
        }
        return this.maxSelectedModifiers;
    }

    @JsonIgnore
    public Optional<Boolean> getEnabled() {
        if (this.enabled == null) {
            return Optional.empty();
        }
        return this.enabled;
    }

    @JsonIgnore
    public Optional<Integer> getOrdinal() {
        if (this.ordinal == null) {
            return Optional.empty();
        }
        return this.ordinal;
    }

    @JsonProperty(value="allow_quantities")
    public Optional<Object> getAllowQuantities() {
        return this.allowQuantities;
    }

    @JsonProperty(value="is_conversational")
    public Optional<Object> getIsConversational() {
        return this.isConversational;
    }

    @JsonProperty(value="hidden_from_customer_override")
    public Optional<Object> getHiddenFromCustomerOverride() {
        return this.hiddenFromCustomerOverride;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="modifier_overrides")
    private Optional<List<CatalogModifierOverride>> _getModifierOverrides() {
        return this.modifierOverrides;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="min_selected_modifiers")
    private Optional<Integer> _getMinSelectedModifiers() {
        return this.minSelectedModifiers;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="max_selected_modifiers")
    private Optional<Integer> _getMaxSelectedModifiers() {
        return this.maxSelectedModifiers;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="enabled")
    private Optional<Boolean> _getEnabled() {
        return this.enabled;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="ordinal")
    private Optional<Integer> _getOrdinal() {
        return this.ordinal;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CatalogItemModifierListInfo && this.equalTo((CatalogItemModifierListInfo)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CatalogItemModifierListInfo other) {
        return this.modifierListId.equals(other.modifierListId) && this.modifierOverrides.equals(other.modifierOverrides) && this.minSelectedModifiers.equals(other.minSelectedModifiers) && this.maxSelectedModifiers.equals(other.maxSelectedModifiers) && this.enabled.equals(other.enabled) && this.ordinal.equals(other.ordinal) && this.allowQuantities.equals(other.allowQuantities) && this.isConversational.equals(other.isConversational) && this.hiddenFromCustomerOverride.equals(other.hiddenFromCustomerOverride);
    }

    public int hashCode() {
        return Objects.hash(this.modifierListId, this.modifierOverrides, this.minSelectedModifiers, this.maxSelectedModifiers, this.enabled, this.ordinal, this.allowQuantities, this.isConversational, this.hiddenFromCustomerOverride);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ModifierListIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ModifierListIdStage,
    _FinalStage {
        private String modifierListId;
        private Optional<Object> hiddenFromCustomerOverride = Optional.empty();
        private Optional<Object> isConversational = Optional.empty();
        private Optional<Object> allowQuantities = Optional.empty();
        private Optional<Integer> ordinal = Optional.empty();
        private Optional<Boolean> enabled = Optional.empty();
        private Optional<Integer> maxSelectedModifiers = Optional.empty();
        private Optional<Integer> minSelectedModifiers = Optional.empty();
        private Optional<List<CatalogModifierOverride>> modifierOverrides = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CatalogItemModifierListInfo other) {
            this.modifierListId(other.getModifierListId());
            this.modifierOverrides(other.getModifierOverrides());
            this.minSelectedModifiers(other.getMinSelectedModifiers());
            this.maxSelectedModifiers(other.getMaxSelectedModifiers());
            this.enabled(other.getEnabled());
            this.ordinal(other.getOrdinal());
            this.allowQuantities(other.getAllowQuantities());
            this.isConversational(other.getIsConversational());
            this.hiddenFromCustomerOverride(other.getHiddenFromCustomerOverride());
            return this;
        }

        @Override
        @JsonSetter(value="modifier_list_id")
        public _FinalStage modifierListId(@NotNull String modifierListId) {
            this.modifierListId = Objects.requireNonNull(modifierListId, "modifierListId must not be null");
            return this;
        }

        @Override
        public _FinalStage hiddenFromCustomerOverride(Object hiddenFromCustomerOverride) {
            this.hiddenFromCustomerOverride = Optional.ofNullable(hiddenFromCustomerOverride);
            return this;
        }

        @Override
        @JsonSetter(value="hidden_from_customer_override", nulls=Nulls.SKIP)
        public _FinalStage hiddenFromCustomerOverride(Optional<Object> hiddenFromCustomerOverride) {
            this.hiddenFromCustomerOverride = hiddenFromCustomerOverride;
            return this;
        }

        @Override
        public _FinalStage isConversational(Object isConversational) {
            this.isConversational = Optional.ofNullable(isConversational);
            return this;
        }

        @Override
        @JsonSetter(value="is_conversational", nulls=Nulls.SKIP)
        public _FinalStage isConversational(Optional<Object> isConversational) {
            this.isConversational = isConversational;
            return this;
        }

        @Override
        public _FinalStage allowQuantities(Object allowQuantities) {
            this.allowQuantities = Optional.ofNullable(allowQuantities);
            return this;
        }

        @Override
        @JsonSetter(value="allow_quantities", nulls=Nulls.SKIP)
        public _FinalStage allowQuantities(Optional<Object> allowQuantities) {
            this.allowQuantities = allowQuantities;
            return this;
        }

        @Override
        public _FinalStage ordinal(Nullable<Integer> ordinal) {
            this.ordinal = ordinal.isNull() ? null : (ordinal.isEmpty() ? Optional.empty() : Optional.of(ordinal.get()));
            return this;
        }

        @Override
        public _FinalStage ordinal(Integer ordinal) {
            this.ordinal = Optional.ofNullable(ordinal);
            return this;
        }

        @Override
        @JsonSetter(value="ordinal", nulls=Nulls.SKIP)
        public _FinalStage ordinal(Optional<Integer> ordinal) {
            this.ordinal = ordinal;
            return this;
        }

        @Override
        public _FinalStage enabled(Nullable<Boolean> enabled) {
            this.enabled = enabled.isNull() ? null : (enabled.isEmpty() ? Optional.empty() : Optional.of(enabled.get()));
            return this;
        }

        @Override
        public _FinalStage enabled(Boolean enabled) {
            this.enabled = Optional.ofNullable(enabled);
            return this;
        }

        @Override
        @JsonSetter(value="enabled", nulls=Nulls.SKIP)
        public _FinalStage enabled(Optional<Boolean> enabled) {
            this.enabled = enabled;
            return this;
        }

        @Override
        public _FinalStage maxSelectedModifiers(Nullable<Integer> maxSelectedModifiers) {
            this.maxSelectedModifiers = maxSelectedModifiers.isNull() ? null : (maxSelectedModifiers.isEmpty() ? Optional.empty() : Optional.of(maxSelectedModifiers.get()));
            return this;
        }

        @Override
        public _FinalStage maxSelectedModifiers(Integer maxSelectedModifiers) {
            this.maxSelectedModifiers = Optional.ofNullable(maxSelectedModifiers);
            return this;
        }

        @Override
        @JsonSetter(value="max_selected_modifiers", nulls=Nulls.SKIP)
        public _FinalStage maxSelectedModifiers(Optional<Integer> maxSelectedModifiers) {
            this.maxSelectedModifiers = maxSelectedModifiers;
            return this;
        }

        @Override
        public _FinalStage minSelectedModifiers(Nullable<Integer> minSelectedModifiers) {
            this.minSelectedModifiers = minSelectedModifiers.isNull() ? null : (minSelectedModifiers.isEmpty() ? Optional.empty() : Optional.of(minSelectedModifiers.get()));
            return this;
        }

        @Override
        public _FinalStage minSelectedModifiers(Integer minSelectedModifiers) {
            this.minSelectedModifiers = Optional.ofNullable(minSelectedModifiers);
            return this;
        }

        @Override
        @JsonSetter(value="min_selected_modifiers", nulls=Nulls.SKIP)
        public _FinalStage minSelectedModifiers(Optional<Integer> minSelectedModifiers) {
            this.minSelectedModifiers = minSelectedModifiers;
            return this;
        }

        @Override
        public _FinalStage modifierOverrides(Nullable<List<CatalogModifierOverride>> modifierOverrides) {
            this.modifierOverrides = modifierOverrides.isNull() ? null : (modifierOverrides.isEmpty() ? Optional.empty() : Optional.of(modifierOverrides.get()));
            return this;
        }

        @Override
        public _FinalStage modifierOverrides(List<CatalogModifierOverride> modifierOverrides) {
            this.modifierOverrides = Optional.ofNullable(modifierOverrides);
            return this;
        }

        @Override
        @JsonSetter(value="modifier_overrides", nulls=Nulls.SKIP)
        public _FinalStage modifierOverrides(Optional<List<CatalogModifierOverride>> modifierOverrides) {
            this.modifierOverrides = modifierOverrides;
            return this;
        }

        @Override
        public CatalogItemModifierListInfo build() {
            return new CatalogItemModifierListInfo(this.modifierListId, this.modifierOverrides, this.minSelectedModifiers, this.maxSelectedModifiers, this.enabled, this.ordinal, this.allowQuantities, this.isConversational, this.hiddenFromCustomerOverride, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CatalogItemModifierListInfo build();

        public _FinalStage modifierOverrides(Optional<List<CatalogModifierOverride>> var1);

        public _FinalStage modifierOverrides(List<CatalogModifierOverride> var1);

        public _FinalStage modifierOverrides(Nullable<List<CatalogModifierOverride>> var1);

        public _FinalStage minSelectedModifiers(Optional<Integer> var1);

        public _FinalStage minSelectedModifiers(Integer var1);

        public _FinalStage minSelectedModifiers(Nullable<Integer> var1);

        public _FinalStage maxSelectedModifiers(Optional<Integer> var1);

        public _FinalStage maxSelectedModifiers(Integer var1);

        public _FinalStage maxSelectedModifiers(Nullable<Integer> var1);

        public _FinalStage enabled(Optional<Boolean> var1);

        public _FinalStage enabled(Boolean var1);

        public _FinalStage enabled(Nullable<Boolean> var1);

        public _FinalStage ordinal(Optional<Integer> var1);

        public _FinalStage ordinal(Integer var1);

        public _FinalStage ordinal(Nullable<Integer> var1);

        public _FinalStage allowQuantities(Optional<Object> var1);

        public _FinalStage allowQuantities(Object var1);

        public _FinalStage isConversational(Optional<Object> var1);

        public _FinalStage isConversational(Object var1);

        public _FinalStage hiddenFromCustomerOverride(Optional<Object> var1);

        public _FinalStage hiddenFromCustomerOverride(Object var1);
    }

    public static interface ModifierListIdStage {
        public _FinalStage modifierListId(@NotNull String var1);

        public Builder from(CatalogItemModifierListInfo var1);
    }
}

