/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CatalogIdMapping {
    private final Optional<String> clientObjectId;
    private final Optional<String> objectId;
    private final Map<String, Object> additionalProperties;

    private CatalogIdMapping(Optional<String> clientObjectId, Optional<String> objectId, Map<String, Object> additionalProperties) {
        this.clientObjectId = clientObjectId;
        this.objectId = objectId;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getClientObjectId() {
        if (this.clientObjectId == null) {
            return Optional.empty();
        }
        return this.clientObjectId;
    }

    @JsonIgnore
    public Optional<String> getObjectId() {
        if (this.objectId == null) {
            return Optional.empty();
        }
        return this.objectId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="client_object_id")
    private Optional<String> _getClientObjectId() {
        return this.clientObjectId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="object_id")
    private Optional<String> _getObjectId() {
        return this.objectId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CatalogIdMapping && this.equalTo((CatalogIdMapping)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CatalogIdMapping other) {
        return this.clientObjectId.equals(other.clientObjectId) && this.objectId.equals(other.objectId);
    }

    public int hashCode() {
        return Objects.hash(this.clientObjectId, this.objectId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> clientObjectId = Optional.empty();
        private Optional<String> objectId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CatalogIdMapping other) {
            this.clientObjectId(other.getClientObjectId());
            this.objectId(other.getObjectId());
            return this;
        }

        @JsonSetter(value="client_object_id", nulls=Nulls.SKIP)
        public Builder clientObjectId(Optional<String> clientObjectId) {
            this.clientObjectId = clientObjectId;
            return this;
        }

        public Builder clientObjectId(String clientObjectId) {
            this.clientObjectId = Optional.ofNullable(clientObjectId);
            return this;
        }

        public Builder clientObjectId(Nullable<String> clientObjectId) {
            this.clientObjectId = clientObjectId.isNull() ? null : (clientObjectId.isEmpty() ? Optional.empty() : Optional.of(clientObjectId.get()));
            return this;
        }

        @JsonSetter(value="object_id", nulls=Nulls.SKIP)
        public Builder objectId(Optional<String> objectId) {
            this.objectId = objectId;
            return this;
        }

        public Builder objectId(String objectId) {
            this.objectId = Optional.ofNullable(objectId);
            return this;
        }

        public Builder objectId(Nullable<String> objectId) {
            this.objectId = objectId.isNull() ? null : (objectId.isEmpty() ? Optional.empty() : Optional.of(objectId.get()));
            return this;
        }

        public CatalogIdMapping build() {
            return new CatalogIdMapping(this.clientObjectId, this.objectId, this.additionalProperties);
        }
    }
}

