/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CatalogDiscountModifyTaxBasis;
import com.squareup.square.types.CatalogDiscountType;
import com.squareup.square.types.Money;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CatalogDiscount {
    private final Optional<String> name;
    private final Optional<CatalogDiscountType> discountType;
    private final Optional<String> percentage;
    private final Optional<Money> amountMoney;
    private final Optional<Boolean> pinRequired;
    private final Optional<String> labelColor;
    private final Optional<CatalogDiscountModifyTaxBasis> modifyTaxBasis;
    private final Optional<Money> maximumAmountMoney;
    private final Map<String, Object> additionalProperties;

    private CatalogDiscount(Optional<String> name, Optional<CatalogDiscountType> discountType, Optional<String> percentage, Optional<Money> amountMoney, Optional<Boolean> pinRequired, Optional<String> labelColor, Optional<CatalogDiscountModifyTaxBasis> modifyTaxBasis, Optional<Money> maximumAmountMoney, Map<String, Object> additionalProperties) {
        this.name = name;
        this.discountType = discountType;
        this.percentage = percentage;
        this.amountMoney = amountMoney;
        this.pinRequired = pinRequired;
        this.labelColor = labelColor;
        this.modifyTaxBasis = modifyTaxBasis;
        this.maximumAmountMoney = maximumAmountMoney;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getName() {
        if (this.name == null) {
            return Optional.empty();
        }
        return this.name;
    }

    @JsonProperty(value="discount_type")
    public Optional<CatalogDiscountType> getDiscountType() {
        return this.discountType;
    }

    @JsonIgnore
    public Optional<String> getPercentage() {
        if (this.percentage == null) {
            return Optional.empty();
        }
        return this.percentage;
    }

    @JsonProperty(value="amount_money")
    public Optional<Money> getAmountMoney() {
        return this.amountMoney;
    }

    @JsonIgnore
    public Optional<Boolean> getPinRequired() {
        if (this.pinRequired == null) {
            return Optional.empty();
        }
        return this.pinRequired;
    }

    @JsonIgnore
    public Optional<String> getLabelColor() {
        if (this.labelColor == null) {
            return Optional.empty();
        }
        return this.labelColor;
    }

    @JsonProperty(value="modify_tax_basis")
    public Optional<CatalogDiscountModifyTaxBasis> getModifyTaxBasis() {
        return this.modifyTaxBasis;
    }

    @JsonProperty(value="maximum_amount_money")
    public Optional<Money> getMaximumAmountMoney() {
        return this.maximumAmountMoney;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="name")
    private Optional<String> _getName() {
        return this.name;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="percentage")
    private Optional<String> _getPercentage() {
        return this.percentage;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="pin_required")
    private Optional<Boolean> _getPinRequired() {
        return this.pinRequired;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="label_color")
    private Optional<String> _getLabelColor() {
        return this.labelColor;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CatalogDiscount && this.equalTo((CatalogDiscount)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CatalogDiscount other) {
        return this.name.equals(other.name) && this.discountType.equals(other.discountType) && this.percentage.equals(other.percentage) && this.amountMoney.equals(other.amountMoney) && this.pinRequired.equals(other.pinRequired) && this.labelColor.equals(other.labelColor) && this.modifyTaxBasis.equals(other.modifyTaxBasis) && this.maximumAmountMoney.equals(other.maximumAmountMoney);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.discountType, this.percentage, this.amountMoney, this.pinRequired, this.labelColor, this.modifyTaxBasis, this.maximumAmountMoney);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> name = Optional.empty();
        private Optional<CatalogDiscountType> discountType = Optional.empty();
        private Optional<String> percentage = Optional.empty();
        private Optional<Money> amountMoney = Optional.empty();
        private Optional<Boolean> pinRequired = Optional.empty();
        private Optional<String> labelColor = Optional.empty();
        private Optional<CatalogDiscountModifyTaxBasis> modifyTaxBasis = Optional.empty();
        private Optional<Money> maximumAmountMoney = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CatalogDiscount other) {
            this.name(other.getName());
            this.discountType(other.getDiscountType());
            this.percentage(other.getPercentage());
            this.amountMoney(other.getAmountMoney());
            this.pinRequired(other.getPinRequired());
            this.labelColor(other.getLabelColor());
            this.modifyTaxBasis(other.getModifyTaxBasis());
            this.maximumAmountMoney(other.getMaximumAmountMoney());
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        public Builder name(Nullable<String> name) {
            this.name = name.isNull() ? null : (name.isEmpty() ? Optional.empty() : Optional.of(name.get()));
            return this;
        }

        @JsonSetter(value="discount_type", nulls=Nulls.SKIP)
        public Builder discountType(Optional<CatalogDiscountType> discountType) {
            this.discountType = discountType;
            return this;
        }

        public Builder discountType(CatalogDiscountType discountType) {
            this.discountType = Optional.ofNullable(discountType);
            return this;
        }

        @JsonSetter(value="percentage", nulls=Nulls.SKIP)
        public Builder percentage(Optional<String> percentage) {
            this.percentage = percentage;
            return this;
        }

        public Builder percentage(String percentage) {
            this.percentage = Optional.ofNullable(percentage);
            return this;
        }

        public Builder percentage(Nullable<String> percentage) {
            this.percentage = percentage.isNull() ? null : (percentage.isEmpty() ? Optional.empty() : Optional.of(percentage.get()));
            return this;
        }

        @JsonSetter(value="amount_money", nulls=Nulls.SKIP)
        public Builder amountMoney(Optional<Money> amountMoney) {
            this.amountMoney = amountMoney;
            return this;
        }

        public Builder amountMoney(Money amountMoney) {
            this.amountMoney = Optional.ofNullable(amountMoney);
            return this;
        }

        @JsonSetter(value="pin_required", nulls=Nulls.SKIP)
        public Builder pinRequired(Optional<Boolean> pinRequired) {
            this.pinRequired = pinRequired;
            return this;
        }

        public Builder pinRequired(Boolean pinRequired) {
            this.pinRequired = Optional.ofNullable(pinRequired);
            return this;
        }

        public Builder pinRequired(Nullable<Boolean> pinRequired) {
            this.pinRequired = pinRequired.isNull() ? null : (pinRequired.isEmpty() ? Optional.empty() : Optional.of(pinRequired.get()));
            return this;
        }

        @JsonSetter(value="label_color", nulls=Nulls.SKIP)
        public Builder labelColor(Optional<String> labelColor) {
            this.labelColor = labelColor;
            return this;
        }

        public Builder labelColor(String labelColor) {
            this.labelColor = Optional.ofNullable(labelColor);
            return this;
        }

        public Builder labelColor(Nullable<String> labelColor) {
            this.labelColor = labelColor.isNull() ? null : (labelColor.isEmpty() ? Optional.empty() : Optional.of(labelColor.get()));
            return this;
        }

        @JsonSetter(value="modify_tax_basis", nulls=Nulls.SKIP)
        public Builder modifyTaxBasis(Optional<CatalogDiscountModifyTaxBasis> modifyTaxBasis) {
            this.modifyTaxBasis = modifyTaxBasis;
            return this;
        }

        public Builder modifyTaxBasis(CatalogDiscountModifyTaxBasis modifyTaxBasis) {
            this.modifyTaxBasis = Optional.ofNullable(modifyTaxBasis);
            return this;
        }

        @JsonSetter(value="maximum_amount_money", nulls=Nulls.SKIP)
        public Builder maximumAmountMoney(Optional<Money> maximumAmountMoney) {
            this.maximumAmountMoney = maximumAmountMoney;
            return this;
        }

        public Builder maximumAmountMoney(Money maximumAmountMoney) {
            this.maximumAmountMoney = Optional.ofNullable(maximumAmountMoney);
            return this;
        }

        public CatalogDiscount build() {
            return new CatalogDiscount(this.name, this.discountType, this.percentage, this.amountMoney, this.pinRequired, this.labelColor, this.modifyTaxBasis, this.maximumAmountMoney, this.additionalProperties);
        }
    }
}

