/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CatalogCustomAttributeDefinitionType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CatalogCustomAttributeValue {
    private final Optional<String> name;
    private final Optional<String> stringValue;
    private final Optional<String> customAttributeDefinitionId;
    private final Optional<CatalogCustomAttributeDefinitionType> type;
    private final Optional<String> numberValue;
    private final Optional<Boolean> booleanValue;
    private final Optional<List<String>> selectionUidValues;
    private final Optional<String> key;
    private final Map<String, Object> additionalProperties;

    private CatalogCustomAttributeValue(Optional<String> name, Optional<String> stringValue, Optional<String> customAttributeDefinitionId, Optional<CatalogCustomAttributeDefinitionType> type, Optional<String> numberValue, Optional<Boolean> booleanValue, Optional<List<String>> selectionUidValues, Optional<String> key, Map<String, Object> additionalProperties) {
        this.name = name;
        this.stringValue = stringValue;
        this.customAttributeDefinitionId = customAttributeDefinitionId;
        this.type = type;
        this.numberValue = numberValue;
        this.booleanValue = booleanValue;
        this.selectionUidValues = selectionUidValues;
        this.key = key;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getName() {
        if (this.name == null) {
            return Optional.empty();
        }
        return this.name;
    }

    @JsonIgnore
    public Optional<String> getStringValue() {
        if (this.stringValue == null) {
            return Optional.empty();
        }
        return this.stringValue;
    }

    @JsonProperty(value="custom_attribute_definition_id")
    public Optional<String> getCustomAttributeDefinitionId() {
        return this.customAttributeDefinitionId;
    }

    @JsonProperty(value="type")
    public Optional<CatalogCustomAttributeDefinitionType> getType() {
        return this.type;
    }

    @JsonIgnore
    public Optional<String> getNumberValue() {
        if (this.numberValue == null) {
            return Optional.empty();
        }
        return this.numberValue;
    }

    @JsonIgnore
    public Optional<Boolean> getBooleanValue() {
        if (this.booleanValue == null) {
            return Optional.empty();
        }
        return this.booleanValue;
    }

    @JsonIgnore
    public Optional<List<String>> getSelectionUidValues() {
        if (this.selectionUidValues == null) {
            return Optional.empty();
        }
        return this.selectionUidValues;
    }

    @JsonProperty(value="key")
    public Optional<String> getKey() {
        return this.key;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="name")
    private Optional<String> _getName() {
        return this.name;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="string_value")
    private Optional<String> _getStringValue() {
        return this.stringValue;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="number_value")
    private Optional<String> _getNumberValue() {
        return this.numberValue;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="boolean_value")
    private Optional<Boolean> _getBooleanValue() {
        return this.booleanValue;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="selection_uid_values")
    private Optional<List<String>> _getSelectionUidValues() {
        return this.selectionUidValues;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CatalogCustomAttributeValue && this.equalTo((CatalogCustomAttributeValue)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CatalogCustomAttributeValue other) {
        return this.name.equals(other.name) && this.stringValue.equals(other.stringValue) && this.customAttributeDefinitionId.equals(other.customAttributeDefinitionId) && this.type.equals(other.type) && this.numberValue.equals(other.numberValue) && this.booleanValue.equals(other.booleanValue) && this.selectionUidValues.equals(other.selectionUidValues) && this.key.equals(other.key);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.stringValue, this.customAttributeDefinitionId, this.type, this.numberValue, this.booleanValue, this.selectionUidValues, this.key);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> name = Optional.empty();
        private Optional<String> stringValue = Optional.empty();
        private Optional<String> customAttributeDefinitionId = Optional.empty();
        private Optional<CatalogCustomAttributeDefinitionType> type = Optional.empty();
        private Optional<String> numberValue = Optional.empty();
        private Optional<Boolean> booleanValue = Optional.empty();
        private Optional<List<String>> selectionUidValues = Optional.empty();
        private Optional<String> key = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CatalogCustomAttributeValue other) {
            this.name(other.getName());
            this.stringValue(other.getStringValue());
            this.customAttributeDefinitionId(other.getCustomAttributeDefinitionId());
            this.type(other.getType());
            this.numberValue(other.getNumberValue());
            this.booleanValue(other.getBooleanValue());
            this.selectionUidValues(other.getSelectionUidValues());
            this.key(other.getKey());
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        public Builder name(Nullable<String> name) {
            this.name = name.isNull() ? null : (name.isEmpty() ? Optional.empty() : Optional.of(name.get()));
            return this;
        }

        @JsonSetter(value="string_value", nulls=Nulls.SKIP)
        public Builder stringValue(Optional<String> stringValue) {
            this.stringValue = stringValue;
            return this;
        }

        public Builder stringValue(String stringValue) {
            this.stringValue = Optional.ofNullable(stringValue);
            return this;
        }

        public Builder stringValue(Nullable<String> stringValue) {
            this.stringValue = stringValue.isNull() ? null : (stringValue.isEmpty() ? Optional.empty() : Optional.of(stringValue.get()));
            return this;
        }

        @JsonSetter(value="custom_attribute_definition_id", nulls=Nulls.SKIP)
        public Builder customAttributeDefinitionId(Optional<String> customAttributeDefinitionId) {
            this.customAttributeDefinitionId = customAttributeDefinitionId;
            return this;
        }

        public Builder customAttributeDefinitionId(String customAttributeDefinitionId) {
            this.customAttributeDefinitionId = Optional.ofNullable(customAttributeDefinitionId);
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<CatalogCustomAttributeDefinitionType> type) {
            this.type = type;
            return this;
        }

        public Builder type(CatalogCustomAttributeDefinitionType type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @JsonSetter(value="number_value", nulls=Nulls.SKIP)
        public Builder numberValue(Optional<String> numberValue) {
            this.numberValue = numberValue;
            return this;
        }

        public Builder numberValue(String numberValue) {
            this.numberValue = Optional.ofNullable(numberValue);
            return this;
        }

        public Builder numberValue(Nullable<String> numberValue) {
            this.numberValue = numberValue.isNull() ? null : (numberValue.isEmpty() ? Optional.empty() : Optional.of(numberValue.get()));
            return this;
        }

        @JsonSetter(value="boolean_value", nulls=Nulls.SKIP)
        public Builder booleanValue(Optional<Boolean> booleanValue) {
            this.booleanValue = booleanValue;
            return this;
        }

        public Builder booleanValue(Boolean booleanValue) {
            this.booleanValue = Optional.ofNullable(booleanValue);
            return this;
        }

        public Builder booleanValue(Nullable<Boolean> booleanValue) {
            this.booleanValue = booleanValue.isNull() ? null : (booleanValue.isEmpty() ? Optional.empty() : Optional.of(booleanValue.get()));
            return this;
        }

        @JsonSetter(value="selection_uid_values", nulls=Nulls.SKIP)
        public Builder selectionUidValues(Optional<List<String>> selectionUidValues) {
            this.selectionUidValues = selectionUidValues;
            return this;
        }

        public Builder selectionUidValues(List<String> selectionUidValues) {
            this.selectionUidValues = Optional.ofNullable(selectionUidValues);
            return this;
        }

        public Builder selectionUidValues(Nullable<List<String>> selectionUidValues) {
            this.selectionUidValues = selectionUidValues.isNull() ? null : (selectionUidValues.isEmpty() ? Optional.empty() : Optional.of(selectionUidValues.get()));
            return this;
        }

        @JsonSetter(value="key", nulls=Nulls.SKIP)
        public Builder key(Optional<String> key) {
            this.key = key;
            return this;
        }

        public Builder key(String key) {
            this.key = Optional.ofNullable(key);
            return this;
        }

        public CatalogCustomAttributeValue build() {
            return new CatalogCustomAttributeValue(this.name, this.stringValue, this.customAttributeDefinitionId, this.type, this.numberValue, this.booleanValue, this.selectionUidValues, this.key, this.additionalProperties);
        }
    }
}

