/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CatalogCustomAttributeDefinitionAppVisibility;
import com.squareup.square.types.CatalogCustomAttributeDefinitionNumberConfig;
import com.squareup.square.types.CatalogCustomAttributeDefinitionSelectionConfig;
import com.squareup.square.types.CatalogCustomAttributeDefinitionSellerVisibility;
import com.squareup.square.types.CatalogCustomAttributeDefinitionStringConfig;
import com.squareup.square.types.CatalogCustomAttributeDefinitionType;
import com.squareup.square.types.CatalogObjectType;
import com.squareup.square.types.SourceApplication;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CatalogCustomAttributeDefinition {
    private final CatalogCustomAttributeDefinitionType type;
    private final String name;
    private final Optional<String> description;
    private final Optional<SourceApplication> sourceApplication;
    private final List<CatalogObjectType> allowedObjectTypes;
    private final Optional<CatalogCustomAttributeDefinitionSellerVisibility> sellerVisibility;
    private final Optional<CatalogCustomAttributeDefinitionAppVisibility> appVisibility;
    private final Optional<CatalogCustomAttributeDefinitionStringConfig> stringConfig;
    private final Optional<CatalogCustomAttributeDefinitionNumberConfig> numberConfig;
    private final Optional<CatalogCustomAttributeDefinitionSelectionConfig> selectionConfig;
    private final Optional<Integer> customAttributeUsageCount;
    private final Optional<String> key;
    private final Map<String, Object> additionalProperties;

    private CatalogCustomAttributeDefinition(CatalogCustomAttributeDefinitionType type, String name, Optional<String> description, Optional<SourceApplication> sourceApplication, List<CatalogObjectType> allowedObjectTypes, Optional<CatalogCustomAttributeDefinitionSellerVisibility> sellerVisibility, Optional<CatalogCustomAttributeDefinitionAppVisibility> appVisibility, Optional<CatalogCustomAttributeDefinitionStringConfig> stringConfig, Optional<CatalogCustomAttributeDefinitionNumberConfig> numberConfig, Optional<CatalogCustomAttributeDefinitionSelectionConfig> selectionConfig, Optional<Integer> customAttributeUsageCount, Optional<String> key, Map<String, Object> additionalProperties) {
        this.type = type;
        this.name = name;
        this.description = description;
        this.sourceApplication = sourceApplication;
        this.allowedObjectTypes = allowedObjectTypes;
        this.sellerVisibility = sellerVisibility;
        this.appVisibility = appVisibility;
        this.stringConfig = stringConfig;
        this.numberConfig = numberConfig;
        this.selectionConfig = selectionConfig;
        this.customAttributeUsageCount = customAttributeUsageCount;
        this.key = key;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public CatalogCustomAttributeDefinitionType getType() {
        return this.type;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonIgnore
    public Optional<String> getDescription() {
        if (this.description == null) {
            return Optional.empty();
        }
        return this.description;
    }

    @JsonProperty(value="source_application")
    public Optional<SourceApplication> getSourceApplication() {
        return this.sourceApplication;
    }

    @JsonProperty(value="allowed_object_types")
    public List<CatalogObjectType> getAllowedObjectTypes() {
        return this.allowedObjectTypes;
    }

    @JsonProperty(value="seller_visibility")
    public Optional<CatalogCustomAttributeDefinitionSellerVisibility> getSellerVisibility() {
        return this.sellerVisibility;
    }

    @JsonProperty(value="app_visibility")
    public Optional<CatalogCustomAttributeDefinitionAppVisibility> getAppVisibility() {
        return this.appVisibility;
    }

    @JsonProperty(value="string_config")
    public Optional<CatalogCustomAttributeDefinitionStringConfig> getStringConfig() {
        return this.stringConfig;
    }

    @JsonProperty(value="number_config")
    public Optional<CatalogCustomAttributeDefinitionNumberConfig> getNumberConfig() {
        return this.numberConfig;
    }

    @JsonProperty(value="selection_config")
    public Optional<CatalogCustomAttributeDefinitionSelectionConfig> getSelectionConfig() {
        return this.selectionConfig;
    }

    @JsonProperty(value="custom_attribute_usage_count")
    public Optional<Integer> getCustomAttributeUsageCount() {
        return this.customAttributeUsageCount;
    }

    @JsonIgnore
    public Optional<String> getKey() {
        if (this.key == null) {
            return Optional.empty();
        }
        return this.key;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="description")
    private Optional<String> _getDescription() {
        return this.description;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="key")
    private Optional<String> _getKey() {
        return this.key;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CatalogCustomAttributeDefinition && this.equalTo((CatalogCustomAttributeDefinition)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CatalogCustomAttributeDefinition other) {
        return this.type.equals(other.type) && this.name.equals(other.name) && this.description.equals(other.description) && this.sourceApplication.equals(other.sourceApplication) && this.allowedObjectTypes.equals(other.allowedObjectTypes) && this.sellerVisibility.equals(other.sellerVisibility) && this.appVisibility.equals(other.appVisibility) && this.stringConfig.equals(other.stringConfig) && this.numberConfig.equals(other.numberConfig) && this.selectionConfig.equals(other.selectionConfig) && this.customAttributeUsageCount.equals(other.customAttributeUsageCount) && this.key.equals(other.key);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.name, this.description, this.sourceApplication, this.allowedObjectTypes, this.sellerVisibility, this.appVisibility, this.stringConfig, this.numberConfig, this.selectionConfig, this.customAttributeUsageCount, this.key);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TypeStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TypeStage,
    NameStage,
    _FinalStage {
        private CatalogCustomAttributeDefinitionType type;
        private String name;
        private Optional<String> key = Optional.empty();
        private Optional<Integer> customAttributeUsageCount = Optional.empty();
        private Optional<CatalogCustomAttributeDefinitionSelectionConfig> selectionConfig = Optional.empty();
        private Optional<CatalogCustomAttributeDefinitionNumberConfig> numberConfig = Optional.empty();
        private Optional<CatalogCustomAttributeDefinitionStringConfig> stringConfig = Optional.empty();
        private Optional<CatalogCustomAttributeDefinitionAppVisibility> appVisibility = Optional.empty();
        private Optional<CatalogCustomAttributeDefinitionSellerVisibility> sellerVisibility = Optional.empty();
        private List<CatalogObjectType> allowedObjectTypes = new ArrayList<CatalogObjectType>();
        private Optional<SourceApplication> sourceApplication = Optional.empty();
        private Optional<String> description = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CatalogCustomAttributeDefinition other) {
            this.type(other.getType());
            this.name(other.getName());
            this.description(other.getDescription());
            this.sourceApplication(other.getSourceApplication());
            this.allowedObjectTypes(other.getAllowedObjectTypes());
            this.sellerVisibility(other.getSellerVisibility());
            this.appVisibility(other.getAppVisibility());
            this.stringConfig(other.getStringConfig());
            this.numberConfig(other.getNumberConfig());
            this.selectionConfig(other.getSelectionConfig());
            this.customAttributeUsageCount(other.getCustomAttributeUsageCount());
            this.key(other.getKey());
            return this;
        }

        @Override
        @JsonSetter(value="type")
        public NameStage type(@NotNull CatalogCustomAttributeDefinitionType type) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public _FinalStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        public _FinalStage key(Nullable<String> key) {
            this.key = key.isNull() ? null : (key.isEmpty() ? Optional.empty() : Optional.of(key.get()));
            return this;
        }

        @Override
        public _FinalStage key(String key) {
            this.key = Optional.ofNullable(key);
            return this;
        }

        @Override
        @JsonSetter(value="key", nulls=Nulls.SKIP)
        public _FinalStage key(Optional<String> key) {
            this.key = key;
            return this;
        }

        @Override
        public _FinalStage customAttributeUsageCount(Integer customAttributeUsageCount) {
            this.customAttributeUsageCount = Optional.ofNullable(customAttributeUsageCount);
            return this;
        }

        @Override
        @JsonSetter(value="custom_attribute_usage_count", nulls=Nulls.SKIP)
        public _FinalStage customAttributeUsageCount(Optional<Integer> customAttributeUsageCount) {
            this.customAttributeUsageCount = customAttributeUsageCount;
            return this;
        }

        @Override
        public _FinalStage selectionConfig(CatalogCustomAttributeDefinitionSelectionConfig selectionConfig) {
            this.selectionConfig = Optional.ofNullable(selectionConfig);
            return this;
        }

        @Override
        @JsonSetter(value="selection_config", nulls=Nulls.SKIP)
        public _FinalStage selectionConfig(Optional<CatalogCustomAttributeDefinitionSelectionConfig> selectionConfig) {
            this.selectionConfig = selectionConfig;
            return this;
        }

        @Override
        public _FinalStage numberConfig(CatalogCustomAttributeDefinitionNumberConfig numberConfig) {
            this.numberConfig = Optional.ofNullable(numberConfig);
            return this;
        }

        @Override
        @JsonSetter(value="number_config", nulls=Nulls.SKIP)
        public _FinalStage numberConfig(Optional<CatalogCustomAttributeDefinitionNumberConfig> numberConfig) {
            this.numberConfig = numberConfig;
            return this;
        }

        @Override
        public _FinalStage stringConfig(CatalogCustomAttributeDefinitionStringConfig stringConfig) {
            this.stringConfig = Optional.ofNullable(stringConfig);
            return this;
        }

        @Override
        @JsonSetter(value="string_config", nulls=Nulls.SKIP)
        public _FinalStage stringConfig(Optional<CatalogCustomAttributeDefinitionStringConfig> stringConfig) {
            this.stringConfig = stringConfig;
            return this;
        }

        @Override
        public _FinalStage appVisibility(CatalogCustomAttributeDefinitionAppVisibility appVisibility) {
            this.appVisibility = Optional.ofNullable(appVisibility);
            return this;
        }

        @Override
        @JsonSetter(value="app_visibility", nulls=Nulls.SKIP)
        public _FinalStage appVisibility(Optional<CatalogCustomAttributeDefinitionAppVisibility> appVisibility) {
            this.appVisibility = appVisibility;
            return this;
        }

        @Override
        public _FinalStage sellerVisibility(CatalogCustomAttributeDefinitionSellerVisibility sellerVisibility) {
            this.sellerVisibility = Optional.ofNullable(sellerVisibility);
            return this;
        }

        @Override
        @JsonSetter(value="seller_visibility", nulls=Nulls.SKIP)
        public _FinalStage sellerVisibility(Optional<CatalogCustomAttributeDefinitionSellerVisibility> sellerVisibility) {
            this.sellerVisibility = sellerVisibility;
            return this;
        }

        @Override
        public _FinalStage addAllAllowedObjectTypes(List<CatalogObjectType> allowedObjectTypes) {
            this.allowedObjectTypes.addAll(allowedObjectTypes);
            return this;
        }

        @Override
        public _FinalStage addAllowedObjectTypes(CatalogObjectType allowedObjectTypes) {
            this.allowedObjectTypes.add(allowedObjectTypes);
            return this;
        }

        @Override
        @JsonSetter(value="allowed_object_types", nulls=Nulls.SKIP)
        public _FinalStage allowedObjectTypes(List<CatalogObjectType> allowedObjectTypes) {
            this.allowedObjectTypes.clear();
            this.allowedObjectTypes.addAll(allowedObjectTypes);
            return this;
        }

        @Override
        public _FinalStage sourceApplication(SourceApplication sourceApplication) {
            this.sourceApplication = Optional.ofNullable(sourceApplication);
            return this;
        }

        @Override
        @JsonSetter(value="source_application", nulls=Nulls.SKIP)
        public _FinalStage sourceApplication(Optional<SourceApplication> sourceApplication) {
            this.sourceApplication = sourceApplication;
            return this;
        }

        @Override
        public _FinalStage description(Nullable<String> description) {
            this.description = description.isNull() ? null : (description.isEmpty() ? Optional.empty() : Optional.of(description.get()));
            return this;
        }

        @Override
        public _FinalStage description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        @Override
        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public _FinalStage description(Optional<String> description) {
            this.description = description;
            return this;
        }

        @Override
        public CatalogCustomAttributeDefinition build() {
            return new CatalogCustomAttributeDefinition(this.type, this.name, this.description, this.sourceApplication, this.allowedObjectTypes, this.sellerVisibility, this.appVisibility, this.stringConfig, this.numberConfig, this.selectionConfig, this.customAttributeUsageCount, this.key, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CatalogCustomAttributeDefinition build();

        public _FinalStage description(Optional<String> var1);

        public _FinalStage description(String var1);

        public _FinalStage description(Nullable<String> var1);

        public _FinalStage sourceApplication(Optional<SourceApplication> var1);

        public _FinalStage sourceApplication(SourceApplication var1);

        public _FinalStage allowedObjectTypes(List<CatalogObjectType> var1);

        public _FinalStage addAllowedObjectTypes(CatalogObjectType var1);

        public _FinalStage addAllAllowedObjectTypes(List<CatalogObjectType> var1);

        public _FinalStage sellerVisibility(Optional<CatalogCustomAttributeDefinitionSellerVisibility> var1);

        public _FinalStage sellerVisibility(CatalogCustomAttributeDefinitionSellerVisibility var1);

        public _FinalStage appVisibility(Optional<CatalogCustomAttributeDefinitionAppVisibility> var1);

        public _FinalStage appVisibility(CatalogCustomAttributeDefinitionAppVisibility var1);

        public _FinalStage stringConfig(Optional<CatalogCustomAttributeDefinitionStringConfig> var1);

        public _FinalStage stringConfig(CatalogCustomAttributeDefinitionStringConfig var1);

        public _FinalStage numberConfig(Optional<CatalogCustomAttributeDefinitionNumberConfig> var1);

        public _FinalStage numberConfig(CatalogCustomAttributeDefinitionNumberConfig var1);

        public _FinalStage selectionConfig(Optional<CatalogCustomAttributeDefinitionSelectionConfig> var1);

        public _FinalStage selectionConfig(CatalogCustomAttributeDefinitionSelectionConfig var1);

        public _FinalStage customAttributeUsageCount(Optional<Integer> var1);

        public _FinalStage customAttributeUsageCount(Integer var1);

        public _FinalStage key(Optional<String> var1);

        public _FinalStage key(String var1);

        public _FinalStage key(Nullable<String> var1);
    }

    public static interface NameStage {
        public _FinalStage name(@NotNull String var1);
    }

    public static interface TypeStage {
        public NameStage type(@NotNull CatalogCustomAttributeDefinitionType var1);

        public Builder from(CatalogCustomAttributeDefinition var1);
    }
}

