/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CatalogCategoryType;
import com.squareup.square.types.CatalogEcomSeoData;
import com.squareup.square.types.CatalogObjectCategory;
import com.squareup.square.types.CategoryPathToRootNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CatalogCategory {
    private final Optional<String> name;
    private final Optional<List<String>> imageIds;
    private final Optional<CatalogCategoryType> categoryType;
    private final Optional<CatalogObjectCategory> parentCategory;
    private final Optional<Boolean> isTopLevel;
    private final Optional<List<String>> channels;
    private final Optional<List<String>> availabilityPeriodIds;
    private final Optional<Boolean> onlineVisibility;
    private final Optional<String> rootCategory;
    private final Optional<CatalogEcomSeoData> ecomSeoData;
    private final Optional<List<CategoryPathToRootNode>> pathToRoot;
    private final Map<String, Object> additionalProperties;

    private CatalogCategory(Optional<String> name, Optional<List<String>> imageIds, Optional<CatalogCategoryType> categoryType, Optional<CatalogObjectCategory> parentCategory, Optional<Boolean> isTopLevel, Optional<List<String>> channels, Optional<List<String>> availabilityPeriodIds, Optional<Boolean> onlineVisibility, Optional<String> rootCategory, Optional<CatalogEcomSeoData> ecomSeoData, Optional<List<CategoryPathToRootNode>> pathToRoot, Map<String, Object> additionalProperties) {
        this.name = name;
        this.imageIds = imageIds;
        this.categoryType = categoryType;
        this.parentCategory = parentCategory;
        this.isTopLevel = isTopLevel;
        this.channels = channels;
        this.availabilityPeriodIds = availabilityPeriodIds;
        this.onlineVisibility = onlineVisibility;
        this.rootCategory = rootCategory;
        this.ecomSeoData = ecomSeoData;
        this.pathToRoot = pathToRoot;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getName() {
        if (this.name == null) {
            return Optional.empty();
        }
        return this.name;
    }

    @JsonIgnore
    public Optional<List<String>> getImageIds() {
        if (this.imageIds == null) {
            return Optional.empty();
        }
        return this.imageIds;
    }

    @JsonProperty(value="category_type")
    public Optional<CatalogCategoryType> getCategoryType() {
        return this.categoryType;
    }

    @JsonProperty(value="parent_category")
    public Optional<CatalogObjectCategory> getParentCategory() {
        return this.parentCategory;
    }

    @JsonIgnore
    public Optional<Boolean> getIsTopLevel() {
        if (this.isTopLevel == null) {
            return Optional.empty();
        }
        return this.isTopLevel;
    }

    @JsonIgnore
    public Optional<List<String>> getChannels() {
        if (this.channels == null) {
            return Optional.empty();
        }
        return this.channels;
    }

    @JsonIgnore
    public Optional<List<String>> getAvailabilityPeriodIds() {
        if (this.availabilityPeriodIds == null) {
            return Optional.empty();
        }
        return this.availabilityPeriodIds;
    }

    @JsonIgnore
    public Optional<Boolean> getOnlineVisibility() {
        if (this.onlineVisibility == null) {
            return Optional.empty();
        }
        return this.onlineVisibility;
    }

    @JsonProperty(value="root_category")
    public Optional<String> getRootCategory() {
        return this.rootCategory;
    }

    @JsonProperty(value="ecom_seo_data")
    public Optional<CatalogEcomSeoData> getEcomSeoData() {
        return this.ecomSeoData;
    }

    @JsonIgnore
    public Optional<List<CategoryPathToRootNode>> getPathToRoot() {
        if (this.pathToRoot == null) {
            return Optional.empty();
        }
        return this.pathToRoot;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="name")
    private Optional<String> _getName() {
        return this.name;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="image_ids")
    private Optional<List<String>> _getImageIds() {
        return this.imageIds;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="is_top_level")
    private Optional<Boolean> _getIsTopLevel() {
        return this.isTopLevel;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="channels")
    private Optional<List<String>> _getChannels() {
        return this.channels;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="availability_period_ids")
    private Optional<List<String>> _getAvailabilityPeriodIds() {
        return this.availabilityPeriodIds;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="online_visibility")
    private Optional<Boolean> _getOnlineVisibility() {
        return this.onlineVisibility;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="path_to_root")
    private Optional<List<CategoryPathToRootNode>> _getPathToRoot() {
        return this.pathToRoot;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CatalogCategory && this.equalTo((CatalogCategory)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CatalogCategory other) {
        return this.name.equals(other.name) && this.imageIds.equals(other.imageIds) && this.categoryType.equals(other.categoryType) && this.parentCategory.equals(other.parentCategory) && this.isTopLevel.equals(other.isTopLevel) && this.channels.equals(other.channels) && this.availabilityPeriodIds.equals(other.availabilityPeriodIds) && this.onlineVisibility.equals(other.onlineVisibility) && this.rootCategory.equals(other.rootCategory) && this.ecomSeoData.equals(other.ecomSeoData) && this.pathToRoot.equals(other.pathToRoot);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.imageIds, this.categoryType, this.parentCategory, this.isTopLevel, this.channels, this.availabilityPeriodIds, this.onlineVisibility, this.rootCategory, this.ecomSeoData, this.pathToRoot);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> name = Optional.empty();
        private Optional<List<String>> imageIds = Optional.empty();
        private Optional<CatalogCategoryType> categoryType = Optional.empty();
        private Optional<CatalogObjectCategory> parentCategory = Optional.empty();
        private Optional<Boolean> isTopLevel = Optional.empty();
        private Optional<List<String>> channels = Optional.empty();
        private Optional<List<String>> availabilityPeriodIds = Optional.empty();
        private Optional<Boolean> onlineVisibility = Optional.empty();
        private Optional<String> rootCategory = Optional.empty();
        private Optional<CatalogEcomSeoData> ecomSeoData = Optional.empty();
        private Optional<List<CategoryPathToRootNode>> pathToRoot = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CatalogCategory other) {
            this.name(other.getName());
            this.imageIds(other.getImageIds());
            this.categoryType(other.getCategoryType());
            this.parentCategory(other.getParentCategory());
            this.isTopLevel(other.getIsTopLevel());
            this.channels(other.getChannels());
            this.availabilityPeriodIds(other.getAvailabilityPeriodIds());
            this.onlineVisibility(other.getOnlineVisibility());
            this.rootCategory(other.getRootCategory());
            this.ecomSeoData(other.getEcomSeoData());
            this.pathToRoot(other.getPathToRoot());
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        public Builder name(Nullable<String> name) {
            this.name = name.isNull() ? null : (name.isEmpty() ? Optional.empty() : Optional.of(name.get()));
            return this;
        }

        @JsonSetter(value="image_ids", nulls=Nulls.SKIP)
        public Builder imageIds(Optional<List<String>> imageIds) {
            this.imageIds = imageIds;
            return this;
        }

        public Builder imageIds(List<String> imageIds) {
            this.imageIds = Optional.ofNullable(imageIds);
            return this;
        }

        public Builder imageIds(Nullable<List<String>> imageIds) {
            this.imageIds = imageIds.isNull() ? null : (imageIds.isEmpty() ? Optional.empty() : Optional.of(imageIds.get()));
            return this;
        }

        @JsonSetter(value="category_type", nulls=Nulls.SKIP)
        public Builder categoryType(Optional<CatalogCategoryType> categoryType) {
            this.categoryType = categoryType;
            return this;
        }

        public Builder categoryType(CatalogCategoryType categoryType) {
            this.categoryType = Optional.ofNullable(categoryType);
            return this;
        }

        @JsonSetter(value="parent_category", nulls=Nulls.SKIP)
        public Builder parentCategory(Optional<CatalogObjectCategory> parentCategory) {
            this.parentCategory = parentCategory;
            return this;
        }

        public Builder parentCategory(CatalogObjectCategory parentCategory) {
            this.parentCategory = Optional.ofNullable(parentCategory);
            return this;
        }

        @JsonSetter(value="is_top_level", nulls=Nulls.SKIP)
        public Builder isTopLevel(Optional<Boolean> isTopLevel) {
            this.isTopLevel = isTopLevel;
            return this;
        }

        public Builder isTopLevel(Boolean isTopLevel) {
            this.isTopLevel = Optional.ofNullable(isTopLevel);
            return this;
        }

        public Builder isTopLevel(Nullable<Boolean> isTopLevel) {
            this.isTopLevel = isTopLevel.isNull() ? null : (isTopLevel.isEmpty() ? Optional.empty() : Optional.of(isTopLevel.get()));
            return this;
        }

        @JsonSetter(value="channels", nulls=Nulls.SKIP)
        public Builder channels(Optional<List<String>> channels) {
            this.channels = channels;
            return this;
        }

        public Builder channels(List<String> channels) {
            this.channels = Optional.ofNullable(channels);
            return this;
        }

        public Builder channels(Nullable<List<String>> channels) {
            this.channels = channels.isNull() ? null : (channels.isEmpty() ? Optional.empty() : Optional.of(channels.get()));
            return this;
        }

        @JsonSetter(value="availability_period_ids", nulls=Nulls.SKIP)
        public Builder availabilityPeriodIds(Optional<List<String>> availabilityPeriodIds) {
            this.availabilityPeriodIds = availabilityPeriodIds;
            return this;
        }

        public Builder availabilityPeriodIds(List<String> availabilityPeriodIds) {
            this.availabilityPeriodIds = Optional.ofNullable(availabilityPeriodIds);
            return this;
        }

        public Builder availabilityPeriodIds(Nullable<List<String>> availabilityPeriodIds) {
            this.availabilityPeriodIds = availabilityPeriodIds.isNull() ? null : (availabilityPeriodIds.isEmpty() ? Optional.empty() : Optional.of(availabilityPeriodIds.get()));
            return this;
        }

        @JsonSetter(value="online_visibility", nulls=Nulls.SKIP)
        public Builder onlineVisibility(Optional<Boolean> onlineVisibility) {
            this.onlineVisibility = onlineVisibility;
            return this;
        }

        public Builder onlineVisibility(Boolean onlineVisibility) {
            this.onlineVisibility = Optional.ofNullable(onlineVisibility);
            return this;
        }

        public Builder onlineVisibility(Nullable<Boolean> onlineVisibility) {
            this.onlineVisibility = onlineVisibility.isNull() ? null : (onlineVisibility.isEmpty() ? Optional.empty() : Optional.of(onlineVisibility.get()));
            return this;
        }

        @JsonSetter(value="root_category", nulls=Nulls.SKIP)
        public Builder rootCategory(Optional<String> rootCategory) {
            this.rootCategory = rootCategory;
            return this;
        }

        public Builder rootCategory(String rootCategory) {
            this.rootCategory = Optional.ofNullable(rootCategory);
            return this;
        }

        @JsonSetter(value="ecom_seo_data", nulls=Nulls.SKIP)
        public Builder ecomSeoData(Optional<CatalogEcomSeoData> ecomSeoData) {
            this.ecomSeoData = ecomSeoData;
            return this;
        }

        public Builder ecomSeoData(CatalogEcomSeoData ecomSeoData) {
            this.ecomSeoData = Optional.ofNullable(ecomSeoData);
            return this;
        }

        @JsonSetter(value="path_to_root", nulls=Nulls.SKIP)
        public Builder pathToRoot(Optional<List<CategoryPathToRootNode>> pathToRoot) {
            this.pathToRoot = pathToRoot;
            return this;
        }

        public Builder pathToRoot(List<CategoryPathToRootNode> pathToRoot) {
            this.pathToRoot = Optional.ofNullable(pathToRoot);
            return this;
        }

        public Builder pathToRoot(Nullable<List<CategoryPathToRootNode>> pathToRoot) {
            this.pathToRoot = pathToRoot.isNull() ? null : (pathToRoot.isEmpty() ? Optional.empty() : Optional.of(pathToRoot.get()));
            return this;
        }

        public CatalogCategory build() {
            return new CatalogCategory(this.name, this.imageIds, this.categoryType, this.parentCategory, this.isTopLevel, this.channels, this.availabilityPeriodIds, this.onlineVisibility, this.rootCategory, this.ecomSeoData, this.pathToRoot, this.additionalProperties);
        }
    }
}

