/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Card;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CardCreatedEventObject {
    private final Optional<Card> card;
    private final Map<String, Object> additionalProperties;

    private CardCreatedEventObject(Optional<Card> card, Map<String, Object> additionalProperties) {
        this.card = card;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="card")
    public Optional<Card> getCard() {
        return this.card;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CardCreatedEventObject && this.equalTo((CardCreatedEventObject)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CardCreatedEventObject other) {
        return this.card.equals(other.card);
    }

    public int hashCode() {
        return Objects.hash(this.card);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Card> card = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CardCreatedEventObject other) {
            this.card(other.getCard());
            return this;
        }

        @JsonSetter(value="card", nulls=Nulls.SKIP)
        public Builder card(Optional<Card> card) {
            this.card = card;
            return this;
        }

        public Builder card(Card card) {
            this.card = Optional.ofNullable(card);
            return this;
        }

        public CardCreatedEventObject build() {
            return new CardCreatedEventObject(this.card, this.additionalProperties);
        }
    }
}

