/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Order;
import com.squareup.square.types.OrderReward;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CalculateOrderRequest {
    private final Order order;
    private final Optional<List<OrderReward>> proposedRewards;
    private final Map<String, Object> additionalProperties;

    private CalculateOrderRequest(Order order, Optional<List<OrderReward>> proposedRewards, Map<String, Object> additionalProperties) {
        this.order = order;
        this.proposedRewards = proposedRewards;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="order")
    public Order getOrder() {
        return this.order;
    }

    @JsonIgnore
    public Optional<List<OrderReward>> getProposedRewards() {
        if (this.proposedRewards == null) {
            return Optional.empty();
        }
        return this.proposedRewards;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="proposed_rewards")
    private Optional<List<OrderReward>> _getProposedRewards() {
        return this.proposedRewards;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CalculateOrderRequest && this.equalTo((CalculateOrderRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CalculateOrderRequest other) {
        return this.order.equals(other.order) && this.proposedRewards.equals(other.proposedRewards);
    }

    public int hashCode() {
        return Objects.hash(this.order, this.proposedRewards);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static OrderStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements OrderStage,
    _FinalStage {
        private Order order;
        private Optional<List<OrderReward>> proposedRewards = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CalculateOrderRequest other) {
            this.order(other.getOrder());
            this.proposedRewards(other.getProposedRewards());
            return this;
        }

        @Override
        @JsonSetter(value="order")
        public _FinalStage order(@NotNull Order order) {
            this.order = Objects.requireNonNull(order, "order must not be null");
            return this;
        }

        @Override
        public _FinalStage proposedRewards(Nullable<List<OrderReward>> proposedRewards) {
            this.proposedRewards = proposedRewards.isNull() ? null : (proposedRewards.isEmpty() ? Optional.empty() : Optional.of(proposedRewards.get()));
            return this;
        }

        @Override
        public _FinalStage proposedRewards(List<OrderReward> proposedRewards) {
            this.proposedRewards = Optional.ofNullable(proposedRewards);
            return this;
        }

        @Override
        @JsonSetter(value="proposed_rewards", nulls=Nulls.SKIP)
        public _FinalStage proposedRewards(Optional<List<OrderReward>> proposedRewards) {
            this.proposedRewards = proposedRewards;
            return this;
        }

        @Override
        public CalculateOrderRequest build() {
            return new CalculateOrderRequest(this.order, this.proposedRewards, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CalculateOrderRequest build();

        public _FinalStage proposedRewards(Optional<List<OrderReward>> var1);

        public _FinalStage proposedRewards(List<OrderReward> var1);

        public _FinalStage proposedRewards(Nullable<List<OrderReward>> var1);
    }

    public static interface OrderStage {
        public _FinalStage order(@NotNull Order var1);

        public Builder from(CalculateOrderRequest var1);
    }
}

