/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.DayOfWeek;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class BusinessHoursPeriod {
    private final Optional<DayOfWeek> dayOfWeek;
    private final Optional<String> startLocalTime;
    private final Optional<String> endLocalTime;
    private final Map<String, Object> additionalProperties;

    private BusinessHoursPeriod(Optional<DayOfWeek> dayOfWeek, Optional<String> startLocalTime, Optional<String> endLocalTime, Map<String, Object> additionalProperties) {
        this.dayOfWeek = dayOfWeek;
        this.startLocalTime = startLocalTime;
        this.endLocalTime = endLocalTime;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="day_of_week")
    public Optional<DayOfWeek> getDayOfWeek() {
        return this.dayOfWeek;
    }

    @JsonIgnore
    public Optional<String> getStartLocalTime() {
        if (this.startLocalTime == null) {
            return Optional.empty();
        }
        return this.startLocalTime;
    }

    @JsonIgnore
    public Optional<String> getEndLocalTime() {
        if (this.endLocalTime == null) {
            return Optional.empty();
        }
        return this.endLocalTime;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="start_local_time")
    private Optional<String> _getStartLocalTime() {
        return this.startLocalTime;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="end_local_time")
    private Optional<String> _getEndLocalTime() {
        return this.endLocalTime;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BusinessHoursPeriod && this.equalTo((BusinessHoursPeriod)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BusinessHoursPeriod other) {
        return this.dayOfWeek.equals(other.dayOfWeek) && this.startLocalTime.equals(other.startLocalTime) && this.endLocalTime.equals(other.endLocalTime);
    }

    public int hashCode() {
        return Objects.hash(this.dayOfWeek, this.startLocalTime, this.endLocalTime);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<DayOfWeek> dayOfWeek = Optional.empty();
        private Optional<String> startLocalTime = Optional.empty();
        private Optional<String> endLocalTime = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(BusinessHoursPeriod other) {
            this.dayOfWeek(other.getDayOfWeek());
            this.startLocalTime(other.getStartLocalTime());
            this.endLocalTime(other.getEndLocalTime());
            return this;
        }

        @JsonSetter(value="day_of_week", nulls=Nulls.SKIP)
        public Builder dayOfWeek(Optional<DayOfWeek> dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
            return this;
        }

        public Builder dayOfWeek(DayOfWeek dayOfWeek) {
            this.dayOfWeek = Optional.ofNullable(dayOfWeek);
            return this;
        }

        @JsonSetter(value="start_local_time", nulls=Nulls.SKIP)
        public Builder startLocalTime(Optional<String> startLocalTime) {
            this.startLocalTime = startLocalTime;
            return this;
        }

        public Builder startLocalTime(String startLocalTime) {
            this.startLocalTime = Optional.ofNullable(startLocalTime);
            return this;
        }

        public Builder startLocalTime(Nullable<String> startLocalTime) {
            this.startLocalTime = startLocalTime.isNull() ? null : (startLocalTime.isEmpty() ? Optional.empty() : Optional.of(startLocalTime.get()));
            return this;
        }

        @JsonSetter(value="end_local_time", nulls=Nulls.SKIP)
        public Builder endLocalTime(Optional<String> endLocalTime) {
            this.endLocalTime = endLocalTime;
            return this;
        }

        public Builder endLocalTime(String endLocalTime) {
            this.endLocalTime = Optional.ofNullable(endLocalTime);
            return this;
        }

        public Builder endLocalTime(Nullable<String> endLocalTime) {
            this.endLocalTime = endLocalTime.isNull() ? null : (endLocalTime.isEmpty() ? Optional.empty() : Optional.of(endLocalTime.get()));
            return this;
        }

        public BusinessHoursPeriod build() {
            return new BusinessHoursPeriod(this.dayOfWeek, this.startLocalTime, this.endLocalTime, this.additionalProperties);
        }
    }
}

