/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.BusinessAppointmentSettings;
import com.squareup.square.types.BusinessBookingProfileBookingPolicy;
import com.squareup.square.types.BusinessBookingProfileCustomerTimezoneChoice;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class BusinessBookingProfile {
    private final Optional<String> sellerId;
    private final Optional<String> createdAt;
    private final Optional<Boolean> bookingEnabled;
    private final Optional<BusinessBookingProfileCustomerTimezoneChoice> customerTimezoneChoice;
    private final Optional<BusinessBookingProfileBookingPolicy> bookingPolicy;
    private final Optional<Boolean> allowUserCancel;
    private final Optional<BusinessAppointmentSettings> businessAppointmentSettings;
    private final Optional<Boolean> supportSellerLevelWrites;
    private final Map<String, Object> additionalProperties;

    private BusinessBookingProfile(Optional<String> sellerId, Optional<String> createdAt, Optional<Boolean> bookingEnabled, Optional<BusinessBookingProfileCustomerTimezoneChoice> customerTimezoneChoice, Optional<BusinessBookingProfileBookingPolicy> bookingPolicy, Optional<Boolean> allowUserCancel, Optional<BusinessAppointmentSettings> businessAppointmentSettings, Optional<Boolean> supportSellerLevelWrites, Map<String, Object> additionalProperties) {
        this.sellerId = sellerId;
        this.createdAt = createdAt;
        this.bookingEnabled = bookingEnabled;
        this.customerTimezoneChoice = customerTimezoneChoice;
        this.bookingPolicy = bookingPolicy;
        this.allowUserCancel = allowUserCancel;
        this.businessAppointmentSettings = businessAppointmentSettings;
        this.supportSellerLevelWrites = supportSellerLevelWrites;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getSellerId() {
        if (this.sellerId == null) {
            return Optional.empty();
        }
        return this.sellerId;
    }

    @JsonProperty(value="created_at")
    public Optional<String> getCreatedAt() {
        return this.createdAt;
    }

    @JsonIgnore
    public Optional<Boolean> getBookingEnabled() {
        if (this.bookingEnabled == null) {
            return Optional.empty();
        }
        return this.bookingEnabled;
    }

    @JsonProperty(value="customer_timezone_choice")
    public Optional<BusinessBookingProfileCustomerTimezoneChoice> getCustomerTimezoneChoice() {
        return this.customerTimezoneChoice;
    }

    @JsonProperty(value="booking_policy")
    public Optional<BusinessBookingProfileBookingPolicy> getBookingPolicy() {
        return this.bookingPolicy;
    }

    @JsonIgnore
    public Optional<Boolean> getAllowUserCancel() {
        if (this.allowUserCancel == null) {
            return Optional.empty();
        }
        return this.allowUserCancel;
    }

    @JsonProperty(value="business_appointment_settings")
    public Optional<BusinessAppointmentSettings> getBusinessAppointmentSettings() {
        return this.businessAppointmentSettings;
    }

    @JsonIgnore
    public Optional<Boolean> getSupportSellerLevelWrites() {
        if (this.supportSellerLevelWrites == null) {
            return Optional.empty();
        }
        return this.supportSellerLevelWrites;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="seller_id")
    private Optional<String> _getSellerId() {
        return this.sellerId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="booking_enabled")
    private Optional<Boolean> _getBookingEnabled() {
        return this.bookingEnabled;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="allow_user_cancel")
    private Optional<Boolean> _getAllowUserCancel() {
        return this.allowUserCancel;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="support_seller_level_writes")
    private Optional<Boolean> _getSupportSellerLevelWrites() {
        return this.supportSellerLevelWrites;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BusinessBookingProfile && this.equalTo((BusinessBookingProfile)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BusinessBookingProfile other) {
        return this.sellerId.equals(other.sellerId) && this.createdAt.equals(other.createdAt) && this.bookingEnabled.equals(other.bookingEnabled) && this.customerTimezoneChoice.equals(other.customerTimezoneChoice) && this.bookingPolicy.equals(other.bookingPolicy) && this.allowUserCancel.equals(other.allowUserCancel) && this.businessAppointmentSettings.equals(other.businessAppointmentSettings) && this.supportSellerLevelWrites.equals(other.supportSellerLevelWrites);
    }

    public int hashCode() {
        return Objects.hash(this.sellerId, this.createdAt, this.bookingEnabled, this.customerTimezoneChoice, this.bookingPolicy, this.allowUserCancel, this.businessAppointmentSettings, this.supportSellerLevelWrites);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> sellerId = Optional.empty();
        private Optional<String> createdAt = Optional.empty();
        private Optional<Boolean> bookingEnabled = Optional.empty();
        private Optional<BusinessBookingProfileCustomerTimezoneChoice> customerTimezoneChoice = Optional.empty();
        private Optional<BusinessBookingProfileBookingPolicy> bookingPolicy = Optional.empty();
        private Optional<Boolean> allowUserCancel = Optional.empty();
        private Optional<BusinessAppointmentSettings> businessAppointmentSettings = Optional.empty();
        private Optional<Boolean> supportSellerLevelWrites = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(BusinessBookingProfile other) {
            this.sellerId(other.getSellerId());
            this.createdAt(other.getCreatedAt());
            this.bookingEnabled(other.getBookingEnabled());
            this.customerTimezoneChoice(other.getCustomerTimezoneChoice());
            this.bookingPolicy(other.getBookingPolicy());
            this.allowUserCancel(other.getAllowUserCancel());
            this.businessAppointmentSettings(other.getBusinessAppointmentSettings());
            this.supportSellerLevelWrites(other.getSupportSellerLevelWrites());
            return this;
        }

        @JsonSetter(value="seller_id", nulls=Nulls.SKIP)
        public Builder sellerId(Optional<String> sellerId) {
            this.sellerId = sellerId;
            return this;
        }

        public Builder sellerId(String sellerId) {
            this.sellerId = Optional.ofNullable(sellerId);
            return this;
        }

        public Builder sellerId(Nullable<String> sellerId) {
            this.sellerId = sellerId.isNull() ? null : (sellerId.isEmpty() ? Optional.empty() : Optional.of(sellerId.get()));
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<String> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @JsonSetter(value="booking_enabled", nulls=Nulls.SKIP)
        public Builder bookingEnabled(Optional<Boolean> bookingEnabled) {
            this.bookingEnabled = bookingEnabled;
            return this;
        }

        public Builder bookingEnabled(Boolean bookingEnabled) {
            this.bookingEnabled = Optional.ofNullable(bookingEnabled);
            return this;
        }

        public Builder bookingEnabled(Nullable<Boolean> bookingEnabled) {
            this.bookingEnabled = bookingEnabled.isNull() ? null : (bookingEnabled.isEmpty() ? Optional.empty() : Optional.of(bookingEnabled.get()));
            return this;
        }

        @JsonSetter(value="customer_timezone_choice", nulls=Nulls.SKIP)
        public Builder customerTimezoneChoice(Optional<BusinessBookingProfileCustomerTimezoneChoice> customerTimezoneChoice) {
            this.customerTimezoneChoice = customerTimezoneChoice;
            return this;
        }

        public Builder customerTimezoneChoice(BusinessBookingProfileCustomerTimezoneChoice customerTimezoneChoice) {
            this.customerTimezoneChoice = Optional.ofNullable(customerTimezoneChoice);
            return this;
        }

        @JsonSetter(value="booking_policy", nulls=Nulls.SKIP)
        public Builder bookingPolicy(Optional<BusinessBookingProfileBookingPolicy> bookingPolicy) {
            this.bookingPolicy = bookingPolicy;
            return this;
        }

        public Builder bookingPolicy(BusinessBookingProfileBookingPolicy bookingPolicy) {
            this.bookingPolicy = Optional.ofNullable(bookingPolicy);
            return this;
        }

        @JsonSetter(value="allow_user_cancel", nulls=Nulls.SKIP)
        public Builder allowUserCancel(Optional<Boolean> allowUserCancel) {
            this.allowUserCancel = allowUserCancel;
            return this;
        }

        public Builder allowUserCancel(Boolean allowUserCancel) {
            this.allowUserCancel = Optional.ofNullable(allowUserCancel);
            return this;
        }

        public Builder allowUserCancel(Nullable<Boolean> allowUserCancel) {
            this.allowUserCancel = allowUserCancel.isNull() ? null : (allowUserCancel.isEmpty() ? Optional.empty() : Optional.of(allowUserCancel.get()));
            return this;
        }

        @JsonSetter(value="business_appointment_settings", nulls=Nulls.SKIP)
        public Builder businessAppointmentSettings(Optional<BusinessAppointmentSettings> businessAppointmentSettings) {
            this.businessAppointmentSettings = businessAppointmentSettings;
            return this;
        }

        public Builder businessAppointmentSettings(BusinessAppointmentSettings businessAppointmentSettings) {
            this.businessAppointmentSettings = Optional.ofNullable(businessAppointmentSettings);
            return this;
        }

        @JsonSetter(value="support_seller_level_writes", nulls=Nulls.SKIP)
        public Builder supportSellerLevelWrites(Optional<Boolean> supportSellerLevelWrites) {
            this.supportSellerLevelWrites = supportSellerLevelWrites;
            return this;
        }

        public Builder supportSellerLevelWrites(Boolean supportSellerLevelWrites) {
            this.supportSellerLevelWrites = Optional.ofNullable(supportSellerLevelWrites);
            return this;
        }

        public Builder supportSellerLevelWrites(Nullable<Boolean> supportSellerLevelWrites) {
            this.supportSellerLevelWrites = supportSellerLevelWrites.isNull() ? null : (supportSellerLevelWrites.isEmpty() ? Optional.empty() : Optional.of(supportSellerLevelWrites.get()));
            return this;
        }

        public BusinessBookingProfile build() {
            return new BusinessBookingProfile(this.sellerId, this.createdAt, this.bookingEnabled, this.customerTimezoneChoice, this.bookingPolicy, this.allowUserCancel, this.businessAppointmentSettings, this.supportSellerLevelWrites, this.additionalProperties);
        }
    }
}

