/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Error;
import com.squareup.square.types.UpdateCustomerResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class BulkUpdateCustomersResponse {
    private final Optional<Map<String, UpdateCustomerResponse>> responses;
    private final Optional<List<Error>> errors;
    private final Map<String, Object> additionalProperties;

    private BulkUpdateCustomersResponse(Optional<Map<String, UpdateCustomerResponse>> responses, Optional<List<Error>> errors, Map<String, Object> additionalProperties) {
        this.responses = responses;
        this.errors = errors;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="responses")
    public Optional<Map<String, UpdateCustomerResponse>> getResponses() {
        return this.responses;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BulkUpdateCustomersResponse && this.equalTo((BulkUpdateCustomersResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BulkUpdateCustomersResponse other) {
        return this.responses.equals(other.responses) && this.errors.equals(other.errors);
    }

    public int hashCode() {
        return Objects.hash(this.responses, this.errors);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Map<String, UpdateCustomerResponse>> responses = Optional.empty();
        private Optional<List<Error>> errors = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(BulkUpdateCustomersResponse other) {
            this.responses(other.getResponses());
            this.errors(other.getErrors());
            return this;
        }

        @JsonSetter(value="responses", nulls=Nulls.SKIP)
        public Builder responses(Optional<Map<String, UpdateCustomerResponse>> responses) {
            this.responses = responses;
            return this;
        }

        public Builder responses(Map<String, UpdateCustomerResponse> responses) {
            this.responses = Optional.ofNullable(responses);
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        public BulkUpdateCustomersResponse build() {
            return new BulkUpdateCustomersResponse(this.responses, this.errors, this.additionalProperties);
        }
    }
}

