/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Error;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class BulkSwapPlanResponse {
    private final Optional<List<Error>> errors;
    private final Optional<Integer> affectedSubscriptions;
    private final Map<String, Object> additionalProperties;

    private BulkSwapPlanResponse(Optional<List<Error>> errors, Optional<Integer> affectedSubscriptions, Map<String, Object> additionalProperties) {
        this.errors = errors;
        this.affectedSubscriptions = affectedSubscriptions;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="affected_subscriptions")
    public Optional<Integer> getAffectedSubscriptions() {
        return this.affectedSubscriptions;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BulkSwapPlanResponse && this.equalTo((BulkSwapPlanResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BulkSwapPlanResponse other) {
        return this.errors.equals(other.errors) && this.affectedSubscriptions.equals(other.affectedSubscriptions);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.affectedSubscriptions);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Error>> errors = Optional.empty();
        private Optional<Integer> affectedSubscriptions = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(BulkSwapPlanResponse other) {
            this.errors(other.getErrors());
            this.affectedSubscriptions(other.getAffectedSubscriptions());
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        @JsonSetter(value="affected_subscriptions", nulls=Nulls.SKIP)
        public Builder affectedSubscriptions(Optional<Integer> affectedSubscriptions) {
            this.affectedSubscriptions = affectedSubscriptions;
            return this;
        }

        public Builder affectedSubscriptions(Integer affectedSubscriptions) {
            this.affectedSubscriptions = Optional.ofNullable(affectedSubscriptions);
            return this;
        }

        public BulkSwapPlanResponse build() {
            return new BulkSwapPlanResponse(this.errors, this.affectedSubscriptions, this.additionalProperties);
        }
    }
}

