/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.BulkPublishScheduledShiftsData;
import com.squareup.square.types.ScheduledShiftNotificationAudience;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class BulkPublishScheduledShiftsRequest {
    private final Map<String, BulkPublishScheduledShiftsData> scheduledShifts;
    private final Optional<ScheduledShiftNotificationAudience> scheduledShiftNotificationAudience;
    private final Map<String, Object> additionalProperties;

    private BulkPublishScheduledShiftsRequest(Map<String, BulkPublishScheduledShiftsData> scheduledShifts, Optional<ScheduledShiftNotificationAudience> scheduledShiftNotificationAudience, Map<String, Object> additionalProperties) {
        this.scheduledShifts = scheduledShifts;
        this.scheduledShiftNotificationAudience = scheduledShiftNotificationAudience;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="scheduled_shifts")
    public Map<String, BulkPublishScheduledShiftsData> getScheduledShifts() {
        return this.scheduledShifts;
    }

    @JsonProperty(value="scheduled_shift_notification_audience")
    public Optional<ScheduledShiftNotificationAudience> getScheduledShiftNotificationAudience() {
        return this.scheduledShiftNotificationAudience;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BulkPublishScheduledShiftsRequest && this.equalTo((BulkPublishScheduledShiftsRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BulkPublishScheduledShiftsRequest other) {
        return this.scheduledShifts.equals(other.scheduledShifts) && this.scheduledShiftNotificationAudience.equals(other.scheduledShiftNotificationAudience);
    }

    public int hashCode() {
        return Objects.hash(this.scheduledShifts, this.scheduledShiftNotificationAudience);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Map<String, BulkPublishScheduledShiftsData> scheduledShifts = new LinkedHashMap<String, BulkPublishScheduledShiftsData>();
        private Optional<ScheduledShiftNotificationAudience> scheduledShiftNotificationAudience = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(BulkPublishScheduledShiftsRequest other) {
            this.scheduledShifts(other.getScheduledShifts());
            this.scheduledShiftNotificationAudience(other.getScheduledShiftNotificationAudience());
            return this;
        }

        @JsonSetter(value="scheduled_shifts", nulls=Nulls.SKIP)
        public Builder scheduledShifts(Map<String, BulkPublishScheduledShiftsData> scheduledShifts) {
            this.scheduledShifts.clear();
            this.scheduledShifts.putAll(scheduledShifts);
            return this;
        }

        public Builder putAllScheduledShifts(Map<String, BulkPublishScheduledShiftsData> scheduledShifts) {
            this.scheduledShifts.putAll(scheduledShifts);
            return this;
        }

        public Builder scheduledShifts(String key, BulkPublishScheduledShiftsData value) {
            this.scheduledShifts.put(key, value);
            return this;
        }

        @JsonSetter(value="scheduled_shift_notification_audience", nulls=Nulls.SKIP)
        public Builder scheduledShiftNotificationAudience(Optional<ScheduledShiftNotificationAudience> scheduledShiftNotificationAudience) {
            this.scheduledShiftNotificationAudience = scheduledShiftNotificationAudience;
            return this;
        }

        public Builder scheduledShiftNotificationAudience(ScheduledShiftNotificationAudience scheduledShiftNotificationAudience) {
            this.scheduledShiftNotificationAudience = Optional.ofNullable(scheduledShiftNotificationAudience);
            return this;
        }

        public BulkPublishScheduledShiftsRequest build() {
            return new BulkPublishScheduledShiftsRequest(this.scheduledShifts, this.scheduledShiftNotificationAudience, this.additionalProperties);
        }
    }
}

