/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CustomAttribute;
import com.squareup.square.types.Error;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class BookingCustomAttributeUpsertResponse {
    private final Optional<String> bookingId;
    private final Optional<CustomAttribute> customAttribute;
    private final Optional<List<Error>> errors;
    private final Map<String, Object> additionalProperties;

    private BookingCustomAttributeUpsertResponse(Optional<String> bookingId, Optional<CustomAttribute> customAttribute, Optional<List<Error>> errors, Map<String, Object> additionalProperties) {
        this.bookingId = bookingId;
        this.customAttribute = customAttribute;
        this.errors = errors;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="booking_id")
    public Optional<String> getBookingId() {
        return this.bookingId;
    }

    @JsonProperty(value="custom_attribute")
    public Optional<CustomAttribute> getCustomAttribute() {
        return this.customAttribute;
    }

    @JsonProperty(value="errors")
    public Optional<List<Error>> getErrors() {
        return this.errors;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BookingCustomAttributeUpsertResponse && this.equalTo((BookingCustomAttributeUpsertResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BookingCustomAttributeUpsertResponse other) {
        return this.bookingId.equals(other.bookingId) && this.customAttribute.equals(other.customAttribute) && this.errors.equals(other.errors);
    }

    public int hashCode() {
        return Objects.hash(this.bookingId, this.customAttribute, this.errors);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> bookingId = Optional.empty();
        private Optional<CustomAttribute> customAttribute = Optional.empty();
        private Optional<List<Error>> errors = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(BookingCustomAttributeUpsertResponse other) {
            this.bookingId(other.getBookingId());
            this.customAttribute(other.getCustomAttribute());
            this.errors(other.getErrors());
            return this;
        }

        @JsonSetter(value="booking_id", nulls=Nulls.SKIP)
        public Builder bookingId(Optional<String> bookingId) {
            this.bookingId = bookingId;
            return this;
        }

        public Builder bookingId(String bookingId) {
            this.bookingId = Optional.ofNullable(bookingId);
            return this;
        }

        @JsonSetter(value="custom_attribute", nulls=Nulls.SKIP)
        public Builder customAttribute(Optional<CustomAttribute> customAttribute) {
            this.customAttribute = customAttribute;
            return this;
        }

        public Builder customAttribute(CustomAttribute customAttribute) {
            this.customAttribute = Optional.ofNullable(customAttribute);
            return this;
        }

        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public Builder errors(Optional<List<Error>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = Optional.ofNullable(errors);
            return this;
        }

        public BookingCustomAttributeUpsertResponse build() {
            return new BookingCustomAttributeUpsertResponse(this.bookingId, this.customAttribute, this.errors, this.additionalProperties);
        }
    }
}

