/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class BookingCustomAttributeDeleteRequest {
    private final String bookingId;
    private final String key;
    private final Map<String, Object> additionalProperties;

    private BookingCustomAttributeDeleteRequest(String bookingId, String key, Map<String, Object> additionalProperties) {
        this.bookingId = bookingId;
        this.key = key;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="booking_id")
    public String getBookingId() {
        return this.bookingId;
    }

    @JsonProperty(value="key")
    public String getKey() {
        return this.key;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BookingCustomAttributeDeleteRequest && this.equalTo((BookingCustomAttributeDeleteRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BookingCustomAttributeDeleteRequest other) {
        return this.bookingId.equals(other.bookingId) && this.key.equals(other.key);
    }

    public int hashCode() {
        return Objects.hash(this.bookingId, this.key);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static BookingIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements BookingIdStage,
    KeyStage,
    _FinalStage {
        private String bookingId;
        private String key;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(BookingCustomAttributeDeleteRequest other) {
            this.bookingId(other.getBookingId());
            this.key(other.getKey());
            return this;
        }

        @Override
        @JsonSetter(value="booking_id")
        public KeyStage bookingId(@NotNull String bookingId) {
            this.bookingId = Objects.requireNonNull(bookingId, "bookingId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="key")
        public _FinalStage key(@NotNull String key) {
            this.key = Objects.requireNonNull(key, "key must not be null");
            return this;
        }

        @Override
        public BookingCustomAttributeDeleteRequest build() {
            return new BookingCustomAttributeDeleteRequest(this.bookingId, this.key, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public BookingCustomAttributeDeleteRequest build();
    }

    public static interface KeyStage {
        public _FinalStage key(@NotNull String var1);
    }

    public static interface BookingIdStage {
        public KeyStage bookingId(@NotNull String var1);

        public Builder from(BookingCustomAttributeDeleteRequest var1);
    }
}

