/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.BookingCreatorDetailsCreatorType;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class BookingCreatorDetails {
    private final Optional<BookingCreatorDetailsCreatorType> creatorType;
    private final Optional<String> teamMemberId;
    private final Optional<String> customerId;
    private final Map<String, Object> additionalProperties;

    private BookingCreatorDetails(Optional<BookingCreatorDetailsCreatorType> creatorType, Optional<String> teamMemberId, Optional<String> customerId, Map<String, Object> additionalProperties) {
        this.creatorType = creatorType;
        this.teamMemberId = teamMemberId;
        this.customerId = customerId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="creator_type")
    public Optional<BookingCreatorDetailsCreatorType> getCreatorType() {
        return this.creatorType;
    }

    @JsonProperty(value="team_member_id")
    public Optional<String> getTeamMemberId() {
        return this.teamMemberId;
    }

    @JsonProperty(value="customer_id")
    public Optional<String> getCustomerId() {
        return this.customerId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BookingCreatorDetails && this.equalTo((BookingCreatorDetails)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BookingCreatorDetails other) {
        return this.creatorType.equals(other.creatorType) && this.teamMemberId.equals(other.teamMemberId) && this.customerId.equals(other.customerId);
    }

    public int hashCode() {
        return Objects.hash(this.creatorType, this.teamMemberId, this.customerId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<BookingCreatorDetailsCreatorType> creatorType = Optional.empty();
        private Optional<String> teamMemberId = Optional.empty();
        private Optional<String> customerId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(BookingCreatorDetails other) {
            this.creatorType(other.getCreatorType());
            this.teamMemberId(other.getTeamMemberId());
            this.customerId(other.getCustomerId());
            return this;
        }

        @JsonSetter(value="creator_type", nulls=Nulls.SKIP)
        public Builder creatorType(Optional<BookingCreatorDetailsCreatorType> creatorType) {
            this.creatorType = creatorType;
            return this;
        }

        public Builder creatorType(BookingCreatorDetailsCreatorType creatorType) {
            this.creatorType = Optional.ofNullable(creatorType);
            return this;
        }

        @JsonSetter(value="team_member_id", nulls=Nulls.SKIP)
        public Builder teamMemberId(Optional<String> teamMemberId) {
            this.teamMemberId = teamMemberId;
            return this;
        }

        public Builder teamMemberId(String teamMemberId) {
            this.teamMemberId = Optional.ofNullable(teamMemberId);
            return this;
        }

        @JsonSetter(value="customer_id", nulls=Nulls.SKIP)
        public Builder customerId(Optional<String> customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder customerId(String customerId) {
            this.customerId = Optional.ofNullable(customerId);
            return this;
        }

        public BookingCreatorDetails build() {
            return new BookingCreatorDetails(this.creatorType, this.teamMemberId, this.customerId, this.additionalProperties);
        }
    }
}

