/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.BookingCreatedEventData;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class BookingCreatedEvent {
    private final Optional<String> merchantId;
    private final Optional<String> type;
    private final Optional<String> eventId;
    private final Optional<String> createdAt;
    private final Optional<BookingCreatedEventData> data;
    private final Map<String, Object> additionalProperties;

    private BookingCreatedEvent(Optional<String> merchantId, Optional<String> type, Optional<String> eventId, Optional<String> createdAt, Optional<BookingCreatedEventData> data, Map<String, Object> additionalProperties) {
        this.merchantId = merchantId;
        this.type = type;
        this.eventId = eventId;
        this.createdAt = createdAt;
        this.data = data;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getMerchantId() {
        if (this.merchantId == null) {
            return Optional.empty();
        }
        return this.merchantId;
    }

    @JsonIgnore
    public Optional<String> getType() {
        if (this.type == null) {
            return Optional.empty();
        }
        return this.type;
    }

    @JsonIgnore
    public Optional<String> getEventId() {
        if (this.eventId == null) {
            return Optional.empty();
        }
        return this.eventId;
    }

    @JsonProperty(value="created_at")
    public Optional<String> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="data")
    public Optional<BookingCreatedEventData> getData() {
        return this.data;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="merchant_id")
    private Optional<String> _getMerchantId() {
        return this.merchantId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="type")
    private Optional<String> _getType() {
        return this.type;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="event_id")
    private Optional<String> _getEventId() {
        return this.eventId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BookingCreatedEvent && this.equalTo((BookingCreatedEvent)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BookingCreatedEvent other) {
        return this.merchantId.equals(other.merchantId) && this.type.equals(other.type) && this.eventId.equals(other.eventId) && this.createdAt.equals(other.createdAt) && this.data.equals(other.data);
    }

    public int hashCode() {
        return Objects.hash(this.merchantId, this.type, this.eventId, this.createdAt, this.data);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> merchantId = Optional.empty();
        private Optional<String> type = Optional.empty();
        private Optional<String> eventId = Optional.empty();
        private Optional<String> createdAt = Optional.empty();
        private Optional<BookingCreatedEventData> data = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(BookingCreatedEvent other) {
            this.merchantId(other.getMerchantId());
            this.type(other.getType());
            this.eventId(other.getEventId());
            this.createdAt(other.getCreatedAt());
            this.data(other.getData());
            return this;
        }

        @JsonSetter(value="merchant_id", nulls=Nulls.SKIP)
        public Builder merchantId(Optional<String> merchantId) {
            this.merchantId = merchantId;
            return this;
        }

        public Builder merchantId(String merchantId) {
            this.merchantId = Optional.ofNullable(merchantId);
            return this;
        }

        public Builder merchantId(Nullable<String> merchantId) {
            this.merchantId = merchantId.isNull() ? null : (merchantId.isEmpty() ? Optional.empty() : Optional.of(merchantId.get()));
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        public Builder type(Nullable<String> type) {
            this.type = type.isNull() ? null : (type.isEmpty() ? Optional.empty() : Optional.of(type.get()));
            return this;
        }

        @JsonSetter(value="event_id", nulls=Nulls.SKIP)
        public Builder eventId(Optional<String> eventId) {
            this.eventId = eventId;
            return this;
        }

        public Builder eventId(String eventId) {
            this.eventId = Optional.ofNullable(eventId);
            return this;
        }

        public Builder eventId(Nullable<String> eventId) {
            this.eventId = eventId.isNull() ? null : (eventId.isEmpty() ? Optional.empty() : Optional.of(eventId.get()));
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<String> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @JsonSetter(value="data", nulls=Nulls.SKIP)
        public Builder data(Optional<BookingCreatedEventData> data) {
            this.data = data;
            return this;
        }

        public Builder data(BookingCreatedEventData data) {
            this.data = Optional.ofNullable(data);
            return this;
        }

        public BookingCreatedEvent build() {
            return new BookingCreatedEvent(this.merchantId, this.type, this.eventId, this.createdAt, this.data, this.additionalProperties);
        }
    }
}

