/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public final class BookingBookingSource {
    public static final BookingBookingSource API = new BookingBookingSource(Value.API, "API");
    public static final BookingBookingSource FIRST_PARTY_BUYER = new BookingBookingSource(Value.FIRST_PARTY_BUYER, "FIRST_PARTY_BUYER");
    public static final BookingBookingSource FIRST_PARTY_MERCHANT = new BookingBookingSource(Value.FIRST_PARTY_MERCHANT, "FIRST_PARTY_MERCHANT");
    public static final BookingBookingSource THIRD_PARTY_BUYER = new BookingBookingSource(Value.THIRD_PARTY_BUYER, "THIRD_PARTY_BUYER");
    private final Value value;
    private final String string;

    BookingBookingSource(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value getEnumValue() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof BookingBookingSource && this.string.equals(((BookingBookingSource)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public <T> T visit(Visitor<T> visitor) {
        switch (this.value) {
            case API: {
                return visitor.visitApi();
            }
            case FIRST_PARTY_BUYER: {
                return visitor.visitFirstPartyBuyer();
            }
            case FIRST_PARTY_MERCHANT: {
                return visitor.visitFirstPartyMerchant();
            }
            case THIRD_PARTY_BUYER: {
                return visitor.visitThirdPartyBuyer();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static BookingBookingSource valueOf(String value) {
        switch (value) {
            case "API": {
                return API;
            }
            case "FIRST_PARTY_BUYER": {
                return FIRST_PARTY_BUYER;
            }
            case "FIRST_PARTY_MERCHANT": {
                return FIRST_PARTY_MERCHANT;
            }
            case "THIRD_PARTY_BUYER": {
                return THIRD_PARTY_BUYER;
            }
        }
        return new BookingBookingSource(Value.UNKNOWN, value);
    }

    public static interface Visitor<T> {
        public T visitFirstPartyMerchant();

        public T visitFirstPartyBuyer();

        public T visitThirdPartyBuyer();

        public T visitApi();

        public T visitUnknown(String var1);
    }

    public static enum Value {
        FIRST_PARTY_MERCHANT,
        FIRST_PARTY_BUYER,
        THIRD_PARTY_BUYER,
        API,
        UNKNOWN;

    }
}

