/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Address;
import com.squareup.square.types.AppointmentSegment;
import com.squareup.square.types.BookingBookingSource;
import com.squareup.square.types.BookingCreatorDetails;
import com.squareup.square.types.BookingStatus;
import com.squareup.square.types.BusinessAppointmentSettingsBookingLocationType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Booking {
    private final Optional<String> id;
    private final Optional<Integer> version;
    private final Optional<BookingStatus> status;
    private final Optional<String> createdAt;
    private final Optional<String> updatedAt;
    private final Optional<String> startAt;
    private final Optional<String> locationId;
    private final Optional<String> customerId;
    private final Optional<String> customerNote;
    private final Optional<String> sellerNote;
    private final Optional<List<AppointmentSegment>> appointmentSegments;
    private final Optional<Integer> transitionTimeMinutes;
    private final Optional<Boolean> allDay;
    private final Optional<BusinessAppointmentSettingsBookingLocationType> locationType;
    private final Optional<BookingCreatorDetails> creatorDetails;
    private final Optional<BookingBookingSource> source;
    private final Optional<Address> address;
    private final Map<String, Object> additionalProperties;

    private Booking(Optional<String> id, Optional<Integer> version, Optional<BookingStatus> status, Optional<String> createdAt, Optional<String> updatedAt, Optional<String> startAt, Optional<String> locationId, Optional<String> customerId, Optional<String> customerNote, Optional<String> sellerNote, Optional<List<AppointmentSegment>> appointmentSegments, Optional<Integer> transitionTimeMinutes, Optional<Boolean> allDay, Optional<BusinessAppointmentSettingsBookingLocationType> locationType, Optional<BookingCreatorDetails> creatorDetails, Optional<BookingBookingSource> source, Optional<Address> address, Map<String, Object> additionalProperties) {
        this.id = id;
        this.version = version;
        this.status = status;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.startAt = startAt;
        this.locationId = locationId;
        this.customerId = customerId;
        this.customerNote = customerNote;
        this.sellerNote = sellerNote;
        this.appointmentSegments = appointmentSegments;
        this.transitionTimeMinutes = transitionTimeMinutes;
        this.allDay = allDay;
        this.locationType = locationType;
        this.creatorDetails = creatorDetails;
        this.source = source;
        this.address = address;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="version")
    public Optional<Integer> getVersion() {
        return this.version;
    }

    @JsonProperty(value="status")
    public Optional<BookingStatus> getStatus() {
        return this.status;
    }

    @JsonProperty(value="created_at")
    public Optional<String> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public Optional<String> getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonIgnore
    public Optional<String> getStartAt() {
        if (this.startAt == null) {
            return Optional.empty();
        }
        return this.startAt;
    }

    @JsonIgnore
    public Optional<String> getLocationId() {
        if (this.locationId == null) {
            return Optional.empty();
        }
        return this.locationId;
    }

    @JsonIgnore
    public Optional<String> getCustomerId() {
        if (this.customerId == null) {
            return Optional.empty();
        }
        return this.customerId;
    }

    @JsonIgnore
    public Optional<String> getCustomerNote() {
        if (this.customerNote == null) {
            return Optional.empty();
        }
        return this.customerNote;
    }

    @JsonIgnore
    public Optional<String> getSellerNote() {
        if (this.sellerNote == null) {
            return Optional.empty();
        }
        return this.sellerNote;
    }

    @JsonIgnore
    public Optional<List<AppointmentSegment>> getAppointmentSegments() {
        if (this.appointmentSegments == null) {
            return Optional.empty();
        }
        return this.appointmentSegments;
    }

    @JsonProperty(value="transition_time_minutes")
    public Optional<Integer> getTransitionTimeMinutes() {
        return this.transitionTimeMinutes;
    }

    @JsonProperty(value="all_day")
    public Optional<Boolean> getAllDay() {
        return this.allDay;
    }

    @JsonProperty(value="location_type")
    public Optional<BusinessAppointmentSettingsBookingLocationType> getLocationType() {
        return this.locationType;
    }

    @JsonProperty(value="creator_details")
    public Optional<BookingCreatorDetails> getCreatorDetails() {
        return this.creatorDetails;
    }

    @JsonProperty(value="source")
    public Optional<BookingBookingSource> getSource() {
        return this.source;
    }

    @JsonProperty(value="address")
    public Optional<Address> getAddress() {
        return this.address;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="start_at")
    private Optional<String> _getStartAt() {
        return this.startAt;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="location_id")
    private Optional<String> _getLocationId() {
        return this.locationId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="customer_id")
    private Optional<String> _getCustomerId() {
        return this.customerId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="customer_note")
    private Optional<String> _getCustomerNote() {
        return this.customerNote;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="seller_note")
    private Optional<String> _getSellerNote() {
        return this.sellerNote;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="appointment_segments")
    private Optional<List<AppointmentSegment>> _getAppointmentSegments() {
        return this.appointmentSegments;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Booking && this.equalTo((Booking)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Booking other) {
        return this.id.equals(other.id) && this.version.equals(other.version) && this.status.equals(other.status) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt) && this.startAt.equals(other.startAt) && this.locationId.equals(other.locationId) && this.customerId.equals(other.customerId) && this.customerNote.equals(other.customerNote) && this.sellerNote.equals(other.sellerNote) && this.appointmentSegments.equals(other.appointmentSegments) && this.transitionTimeMinutes.equals(other.transitionTimeMinutes) && this.allDay.equals(other.allDay) && this.locationType.equals(other.locationType) && this.creatorDetails.equals(other.creatorDetails) && this.source.equals(other.source) && this.address.equals(other.address);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.version, this.status, this.createdAt, this.updatedAt, this.startAt, this.locationId, this.customerId, this.customerNote, this.sellerNote, this.appointmentSegments, this.transitionTimeMinutes, this.allDay, this.locationType, this.creatorDetails, this.source, this.address);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<Integer> version = Optional.empty();
        private Optional<BookingStatus> status = Optional.empty();
        private Optional<String> createdAt = Optional.empty();
        private Optional<String> updatedAt = Optional.empty();
        private Optional<String> startAt = Optional.empty();
        private Optional<String> locationId = Optional.empty();
        private Optional<String> customerId = Optional.empty();
        private Optional<String> customerNote = Optional.empty();
        private Optional<String> sellerNote = Optional.empty();
        private Optional<List<AppointmentSegment>> appointmentSegments = Optional.empty();
        private Optional<Integer> transitionTimeMinutes = Optional.empty();
        private Optional<Boolean> allDay = Optional.empty();
        private Optional<BusinessAppointmentSettingsBookingLocationType> locationType = Optional.empty();
        private Optional<BookingCreatorDetails> creatorDetails = Optional.empty();
        private Optional<BookingBookingSource> source = Optional.empty();
        private Optional<Address> address = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(Booking other) {
            this.id(other.getId());
            this.version(other.getVersion());
            this.status(other.getStatus());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            this.startAt(other.getStartAt());
            this.locationId(other.getLocationId());
            this.customerId(other.getCustomerId());
            this.customerNote(other.getCustomerNote());
            this.sellerNote(other.getSellerNote());
            this.appointmentSegments(other.getAppointmentSegments());
            this.transitionTimeMinutes(other.getTransitionTimeMinutes());
            this.allDay(other.getAllDay());
            this.locationType(other.getLocationType());
            this.creatorDetails(other.getCreatorDetails());
            this.source(other.getSource());
            this.address(other.getAddress());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="version", nulls=Nulls.SKIP)
        public Builder version(Optional<Integer> version) {
            this.version = version;
            return this;
        }

        public Builder version(Integer version) {
            this.version = Optional.ofNullable(version);
            return this;
        }

        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public Builder status(Optional<BookingStatus> status) {
            this.status = status;
            return this;
        }

        public Builder status(BookingStatus status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<String> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public Builder updatedAt(Optional<String> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @JsonSetter(value="start_at", nulls=Nulls.SKIP)
        public Builder startAt(Optional<String> startAt) {
            this.startAt = startAt;
            return this;
        }

        public Builder startAt(String startAt) {
            this.startAt = Optional.ofNullable(startAt);
            return this;
        }

        public Builder startAt(Nullable<String> startAt) {
            this.startAt = startAt.isNull() ? null : (startAt.isEmpty() ? Optional.empty() : Optional.of(startAt.get()));
            return this;
        }

        @JsonSetter(value="location_id", nulls=Nulls.SKIP)
        public Builder locationId(Optional<String> locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = Optional.ofNullable(locationId);
            return this;
        }

        public Builder locationId(Nullable<String> locationId) {
            this.locationId = locationId.isNull() ? null : (locationId.isEmpty() ? Optional.empty() : Optional.of(locationId.get()));
            return this;
        }

        @JsonSetter(value="customer_id", nulls=Nulls.SKIP)
        public Builder customerId(Optional<String> customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder customerId(String customerId) {
            this.customerId = Optional.ofNullable(customerId);
            return this;
        }

        public Builder customerId(Nullable<String> customerId) {
            this.customerId = customerId.isNull() ? null : (customerId.isEmpty() ? Optional.empty() : Optional.of(customerId.get()));
            return this;
        }

        @JsonSetter(value="customer_note", nulls=Nulls.SKIP)
        public Builder customerNote(Optional<String> customerNote) {
            this.customerNote = customerNote;
            return this;
        }

        public Builder customerNote(String customerNote) {
            this.customerNote = Optional.ofNullable(customerNote);
            return this;
        }

        public Builder customerNote(Nullable<String> customerNote) {
            this.customerNote = customerNote.isNull() ? null : (customerNote.isEmpty() ? Optional.empty() : Optional.of(customerNote.get()));
            return this;
        }

        @JsonSetter(value="seller_note", nulls=Nulls.SKIP)
        public Builder sellerNote(Optional<String> sellerNote) {
            this.sellerNote = sellerNote;
            return this;
        }

        public Builder sellerNote(String sellerNote) {
            this.sellerNote = Optional.ofNullable(sellerNote);
            return this;
        }

        public Builder sellerNote(Nullable<String> sellerNote) {
            this.sellerNote = sellerNote.isNull() ? null : (sellerNote.isEmpty() ? Optional.empty() : Optional.of(sellerNote.get()));
            return this;
        }

        @JsonSetter(value="appointment_segments", nulls=Nulls.SKIP)
        public Builder appointmentSegments(Optional<List<AppointmentSegment>> appointmentSegments) {
            this.appointmentSegments = appointmentSegments;
            return this;
        }

        public Builder appointmentSegments(List<AppointmentSegment> appointmentSegments) {
            this.appointmentSegments = Optional.ofNullable(appointmentSegments);
            return this;
        }

        public Builder appointmentSegments(Nullable<List<AppointmentSegment>> appointmentSegments) {
            this.appointmentSegments = appointmentSegments.isNull() ? null : (appointmentSegments.isEmpty() ? Optional.empty() : Optional.of(appointmentSegments.get()));
            return this;
        }

        @JsonSetter(value="transition_time_minutes", nulls=Nulls.SKIP)
        public Builder transitionTimeMinutes(Optional<Integer> transitionTimeMinutes) {
            this.transitionTimeMinutes = transitionTimeMinutes;
            return this;
        }

        public Builder transitionTimeMinutes(Integer transitionTimeMinutes) {
            this.transitionTimeMinutes = Optional.ofNullable(transitionTimeMinutes);
            return this;
        }

        @JsonSetter(value="all_day", nulls=Nulls.SKIP)
        public Builder allDay(Optional<Boolean> allDay) {
            this.allDay = allDay;
            return this;
        }

        public Builder allDay(Boolean allDay) {
            this.allDay = Optional.ofNullable(allDay);
            return this;
        }

        @JsonSetter(value="location_type", nulls=Nulls.SKIP)
        public Builder locationType(Optional<BusinessAppointmentSettingsBookingLocationType> locationType) {
            this.locationType = locationType;
            return this;
        }

        public Builder locationType(BusinessAppointmentSettingsBookingLocationType locationType) {
            this.locationType = Optional.ofNullable(locationType);
            return this;
        }

        @JsonSetter(value="creator_details", nulls=Nulls.SKIP)
        public Builder creatorDetails(Optional<BookingCreatorDetails> creatorDetails) {
            this.creatorDetails = creatorDetails;
            return this;
        }

        public Builder creatorDetails(BookingCreatorDetails creatorDetails) {
            this.creatorDetails = Optional.ofNullable(creatorDetails);
            return this;
        }

        @JsonSetter(value="source", nulls=Nulls.SKIP)
        public Builder source(Optional<BookingBookingSource> source) {
            this.source = source;
            return this;
        }

        public Builder source(BookingBookingSource source) {
            this.source = Optional.ofNullable(source);
            return this;
        }

        @JsonSetter(value="address", nulls=Nulls.SKIP)
        public Builder address(Optional<Address> address) {
            this.address = address;
            return this;
        }

        public Builder address(Address address) {
            this.address = Optional.ofNullable(address);
            return this;
        }

        public Booking build() {
            return new Booking(this.id, this.version, this.status, this.createdAt, this.updatedAt, this.startAt, this.locationId, this.customerId, this.customerNote, this.sellerNote, this.appointmentSegments, this.transitionTimeMinutes, this.allDay, this.locationType, this.creatorDetails, this.source, this.address, this.additionalProperties);
        }
    }
}

